/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.helper.vfx;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.refractionapi.refraction.helper.vec3.Vec3Helper;

public class VFXHelper {
    static Random random = new Random();

    public static void addGlint(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_("Enchantments", (Tag)new ListTag());
        ListTag listtag = tag.m_128437_("Enchantments", 10);
        listtag.add((Object)new CompoundTag());
    }

    public static void summonParticlesAroundEntity(LivingEntity entity, ParticleOptions particleOptions, ServerLevel level, int particleAmount) {
        for (int i = 0; i < particleAmount; ++i) {
            double d0 = random.nextGaussian() * 0.02;
            double d1 = random.nextGaussian() * 0.02;
            double d2 = random.nextGaussian() * 0.02;
            level.m_8767_(particleOptions, entity.m_20208_(1.0), entity.m_20187_() + 0.5, entity.m_20262_(1.0), particleAmount, d0, d1, d2, 0.0);
        }
    }

    public static void summonParticlesAroundEntity(LivingEntity entity, ParticleOptions particleOptions, int particleAmount) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            VFXHelper.summonParticlesAroundEntity(entity, particleOptions, level2, particleAmount);
        }
    }

    public static void shootBeamOfParticles(LivingEntity livingEntity, ParticleOptions particleOptions, double range, Vec3 offset) {
        Level level = livingEntity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 vec3 = livingEntity.m_146892_();
            int x = 0;
            while ((double)x < range) {
                Vec3 vec31 = Vec3Helper.calculateViewVector(livingEntity.m_146909_(), livingEntity.m_146908_()).m_82490_((double)x);
                Vec3 vec32 = vec3.m_82549_(vec31);
                if (!serverLevel.m_8055_(BlockPos.m_274561_((double)vec32.f_82479_, (double)vec32.f_82480_, (double)vec32.f_82481_)).m_60795_()) break;
                VFXHelper.sendLongDistanceParticles(serverLevel, particleOptions, vec32.f_82479_ + offset.f_82479_, vec32.f_82480_ + offset.f_82480_, vec32.f_82481_ + offset.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                ++x;
            }
        }
    }

    public static void particleLine(ParticleOptions particle, Vec3 pos1, Vec3 pos2, ServerLevel serverLevel) {
        int range = (int)pos1.m_82554_(pos2);
        float[] degrees = Vec3Helper.getDegreesBetweenPoints(pos1, pos2);
        for (int x = 0; x < range; ++x) {
            Vec3 vec3 = Vec3Helper.calculateViewVector(degrees[0], degrees[1]).m_82490_((double)(-x));
            Vec3 vec31 = pos1.m_82549_(vec3);
            VFXHelper.sendLongDistanceParticles(serverLevel, particle, vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void sendLongDistanceParticles(ServerLevel serverLevel, ParticleOptions pType, double pPosX, double pPosY, double pPosZ, int pParticleCount, double pXOffset, double pYOffset, double pZOffset, double pSpeed) {
        ClientboundLevelParticlesPacket clientboundlevelparticlespacket = new ClientboundLevelParticlesPacket(pType, true, pPosX, pPosY, pPosZ, (float)pXOffset, (float)pYOffset, (float)pZOffset, (float)pSpeed, pParticleCount);
        for (int j = 0; j < serverLevel.m_6907_().size(); ++j) {
            ServerPlayer serverplayer = (ServerPlayer)serverLevel.m_6907_().get(j);
            BlockPos blockpos = serverplayer.m_20183_();
            if (!blockpos.m_203195_((Position)new Vec3(pPosX, pPosY, pPosZ), 512.0)) continue;
            serverplayer.f_8906_.m_9829_((Packet)clientboundlevelparticlespacket);
        }
    }
}

