/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.helper.voxels;

import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeHelper {
    public final VoxelShape northShape;
    public VoxelShape modifiedShape;

    public VoxelShapeHelper(VoxelShape northShape) {
        this.northShape = northShape;
        this.modifiedShape = northShape;
    }

    public VoxelShapeHelper base() {
        this.modifiedShape = this.northShape;
        return this;
    }

    public VoxelShape getModified() {
        return this.modifiedShape;
    }

    public VoxelShape[] createYVoxels() {
        VoxelShape[] ret = new VoxelShape[]{this.modifiedShape, VoxelShapeHelper.rotateShapeY(this.modifiedShape, 90.0), VoxelShapeHelper.rotateShapeY(this.modifiedShape, 180.0), VoxelShapeHelper.rotateShapeY(this.modifiedShape, 270.0)};
        this.base();
        return ret;
    }

    public VoxelShape[] createXVoxels() {
        VoxelShape[] ret = new VoxelShape[]{this.modifiedShape, VoxelShapeHelper.rotateShapeX(this.modifiedShape, 90.0), VoxelShapeHelper.rotateShapeX(this.modifiedShape, 180.0), VoxelShapeHelper.rotateShapeX(this.modifiedShape, 270.0)};
        this.base();
        return ret;
    }

    public VoxelShape[] createZVoxels() {
        VoxelShape[] ret = new VoxelShape[]{this.modifiedShape, VoxelShapeHelper.rotateShapeZ(this.modifiedShape, 270.0), VoxelShapeHelper.rotateShapeZ(this.modifiedShape, 180.0), VoxelShapeHelper.rotateShapeZ(this.modifiedShape, 90.0)};
        this.base();
        return ret;
    }

    public static VoxelShape[] createFacingVoxels(VoxelShape shape) {
        return new VoxelShape[]{VoxelShapeHelper.rotateShapeX(shape, 270.0), VoxelShapeHelper.rotateShapeX(shape, 90.0), shape, VoxelShapeHelper.rotateShapeY(shape, 180.0), VoxelShapeHelper.rotateShapeY(shape, 270.0), VoxelShapeHelper.rotateShapeY(shape, 90.0)};
    }

    public VoxelShapeHelper rotateShapeY(double angle) {
        this.modifiedShape = VoxelShapeHelper.rotateShapeY(this.modifiedShape, angle);
        return this;
    }

    public VoxelShapeHelper rotateShapeX(double angle) {
        this.modifiedShape = VoxelShapeHelper.rotateShapeX(this.modifiedShape, angle);
        return this;
    }

    public VoxelShapeHelper rotateShapeZ(double angle) {
        this.modifiedShape = VoxelShapeHelper.rotateShapeZ(this.modifiedShape, angle);
        return this;
    }

    private static VoxelShape rotateShapeY(VoxelShape shape, double angle) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = Mth.m_14107_((double)(angle / 90.0));
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    private static VoxelShape rotateShapeX(VoxelShape shape, double angle) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = Mth.m_14107_((double)(angle / 90.0));
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)minX, (double)minZ, (double)(1.0 - maxY), (double)maxX, (double)maxZ, (double)(1.0 - minY)));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    private static VoxelShape rotateShapeZ(VoxelShape shape, double angle) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = Mth.m_14107_((double)(angle / 90.0));
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)minY, (double)(1.0 - maxX), (double)minZ, (double)maxY, (double)(1.0 - minX), (double)maxZ));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static int getYIndex(Direction direction) {
        return direction.m_122424_().m_122416_();
    }

    public static int getXZIndex(Direction direction) {
        return switch (direction) {
            default -> 0;
            case Direction.DOWN -> 1;
            case Direction.SOUTH, Direction.EAST -> 2;
            case Direction.UP -> 3;
        };
    }
}

