/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.helper.voxels;

import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.refractionapi.refraction.helper.registry.block.BaseHorizontalBlock;

public class VoxelUtil {
    public static VoxelShape[] makeHorizontalShapes(VoxelShape northShape) {
        return new VoxelShape[]{VoxelUtil.rotateShape(Direction.SOUTH, northShape), VoxelUtil.rotateShape(Direction.WEST, northShape), northShape, VoxelUtil.rotateShape(Direction.EAST, northShape)};
    }

    public static VoxelShape[] makeRotatedXShape(VoxelShape northShape) {
        return new VoxelShape[]{northShape, VoxelUtil.rotateShapeX(northShape, 90.0), VoxelUtil.rotateShapeX(northShape, 180.0), VoxelUtil.rotateShapeX(northShape, 270.0)};
    }

    public static VoxelShape[] makeRotatedZShape(VoxelShape northShape) {
        return new VoxelShape[]{northShape, VoxelUtil.rotateShapeZ(northShape, 270.0), VoxelUtil.rotateShapeZ(northShape, 180.0), VoxelUtil.rotateShapeZ(northShape, 90.0)};
    }

    private static VoxelShape rotateShape(Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - Direction.NORTH.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static VoxelShape rotateShapeY(VoxelShape shape, double angle) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = Mth.m_14107_((double)(angle / 90.0));
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static VoxelShape rotateShapeX(VoxelShape shape, double angle) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = Mth.m_14107_((double)(angle / 90.0));
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)minX, (double)minZ, (double)(1.0 - maxY), (double)maxX, (double)maxZ, (double)(1.0 - minY)));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static VoxelShape rotateShapeZ(VoxelShape shape, double angle) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = Mth.m_14107_((double)(angle / 90.0));
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)minY, (double)(1.0 - maxX), (double)minZ, (double)maxY, (double)(1.0 - minX), (double)maxZ));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static int getDirection(BlockState state) {
        return ((Direction)state.m_61143_((Property)BaseHorizontalBlock.FACING)).m_122416_();
    }
}

