/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.init;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.util.ArrayList;
import java.util.List;
import net.refractionapi.refraction.Refraction;
import net.refractionapi.refraction.events.RefractionClientEvents;
import net.refractionapi.refraction.feature.scheme.RegisterScreen;
import net.refractionapi.refraction.feature.scheme.ScreenRegistry;
import net.refractionapi.refraction.helper.clazz.ClazzUtil;
import net.refractionapi.refraction.util.InitSelf;

public class ClientInitializers {
    private static final List<Object> initializers = new ArrayList<Object>();
    private static final List<Class<?>> clientInits = new ArrayList();

    public static void setup(ScanResult result) {
        ClientInitializers.getClassesWithAnnotation(result, InitSelf.class).forEach(cl -> {
            if (clientInits.stream().noneMatch(c -> c.getName().matches(cl.getName()))) {
                clientInits.add((Class<?>)cl);
            }
        });
        ClientInitializers.getClassesWithAnnotation(result, RegisterScreen.class).forEach(cl -> ScreenRegistry.register(cl.getAnnotation(RegisterScreen.class).value(), cl));
    }

    public static void scanMod(String modID, String path) {
        ClassGraph.CIRCUMVENT_ENCAPSULATION = ClassGraph.CircumventEncapsulationMethod.NARCISSUS;
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().enableAnnotationInfo().acceptPackages(path).rejectPackages("mixins", "mixin").disableModuleScanning().scan();){
            ClientInitializers.setup(scanResult);
        }
        catch (Exception e) {
            Refraction.LOGGER.error("Couldn't load Mod Package Info [{}]", (Object)modID, (Object)e);
        }
    }

    public static List<Class<?>> getClassesWithAnnotation(ScanResult result, Class<?> annotation) {
        ArrayList ret = new ArrayList();
        if (result == null) {
            return ret;
        }
        return result.getClassesWithAnnotation(annotation.getName()).loadClasses(true);
    }

    public static void clear() {
        initializers.removeIf(obj -> obj.getClass().getAnnotation(InitSelf.class).value());
    }

    static {
        RefractionClientEvents.CLIENT_PLAYER_LEAVE.register(ClientInitializers::clear);
        RefractionClientEvents.CLIENT_PLAYER_JOIN.register(() -> clientInits.forEach(c -> initializers.add(ClazzUtil.create(c, new Object[0]))));
    }
}

