/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.mixin;

import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.refractionapi.refraction.client.ClientData;
import net.refractionapi.refraction.feature.cutscenes.client.ClientCutsceneData;
import net.refractionapi.refraction.mixininterfaces.ICameraMixin;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Camera.class})
public abstract class CameraMixin
implements ICameraMixin {
    @Shadow
    private Entity f_90551_;
    @Unique
    private int shakeStartTick = 0;
    @Unique
    private int shakeDurationTick = 0;
    @Unique
    private float intensity = 10.0f;

    protected CameraMixin() {
    }

    @Inject(at={@At(value="HEAD")}, method={"setup"}, cancellable=true)
    void setupHead(BlockGetter pLevel, Entity pEntity, boolean pDetached, boolean pThirdPersonReverse, float pPartialTick, CallbackInfo ci) {
        if (ClientCutsceneData.cameraID != -1 && pDetached) {
            Minecraft.m_91087_().f_91063_.m_109153_().m_90575_(pLevel, this.f_90551_, false, pThirdPersonReverse, pPartialTick);
            ci.cancel();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setup"})
    void setup(BlockGetter pLevel, Entity pEntity, boolean pDetached, boolean pThirdPersonReverse, float pPartialTick, CallbackInfo ci) {
        if (this.shakeDurationTick != 0) {
            double normalisedIntensity;
            double cameraShakeMultiplier = normalisedIntensity = (double)this.intensity / 10.0;
            if ((double)this.shakeDurationTick <= (double)this.shakeStartTick * 0.8) {
                cameraShakeMultiplier = normalisedIntensity * (double)this.shakeDurationTick / (double)this.shakeStartTick * 0.8;
            }
            double camX = (0.25 - pEntity.m_9236_().f_46441_.m_188500_() / 2.0) * cameraShakeMultiplier;
            double camY = (0.25 - pEntity.m_9236_().f_46441_.m_188500_() / 2.0) * cameraShakeMultiplier;
            this.m_90568_(0.0, camY, camX);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"rotation"}, cancellable=true)
    public void rotation(CallbackInfoReturnable<Quaternionf> cir) {
        if (ClientData.currentZRot != -1.0f) {
            cir.setReturnValue((Object)((Quaternionf)cir.getReturnValue()).rotateZ(ClientData.currentZRot));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    void tick(CallbackInfo ci) {
        if (this.shakeDurationTick > 0) {
            --this.shakeDurationTick;
        }
    }

    @Override
    public void startCameraShake(int durationInTicks, float intensity) {
        this.shakeStartTick = durationInTicks;
        this.shakeDurationTick = durationInTicks;
        this.intensity = Mth.m_14036_((float)intensity, (float)0.0f, (float)10.0f);
    }

    @Shadow
    protected abstract void m_90568_(double var1, double var3, double var5);
}

