/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.mixin;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.refractionapi.refraction.events.RefractionEvents;
import net.refractionapi.refraction.feature.atda.Atda;
import net.refractionapi.refraction.feature.atda.AtdaData;
import net.refractionapi.refraction.feature.atda.IAtdaProvider;
import net.refractionapi.refraction.feature.quest.QuestHandler;
import net.refractionapi.refraction.feature.quest.points.InteractionPoint;
import net.refractionapi.refraction.mixininterfaces.IEntity;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements IEntity {
    @Shadow
    public abstract int m_19879_();

    @Shadow
    public abstract Level m_9236_();

    @Inject(at={@At(value="RETURN")}, method={"interact"})
    public void interact(Player pPlayer, InteractionHand pHand, CallbackInfoReturnable<InteractionResult> cir) {
        if (cir.getReturnValue() != InteractionResult.FAIL && QuestHandler.QUESTS.containsKey(pPlayer.m_20148_())) {
            QuestHandler.QUESTS.get(pPlayer.m_20148_()).getQuestPoints().forEach(questPoint -> {
                if (questPoint instanceof InteractionPoint) {
                    InteractionPoint point = (InteractionPoint)questPoint;
                    point.onInteract((Entity)this);
                }
            });
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void initEntity(EntityType<?> pEntityType, Level pLevel, CallbackInfo ci) {
        RefractionEvents.REGISTER_ATDA.invoker().register(this);
    }

    @Inject(at={@At(value="RETURN")}, method={"saveWithoutId"}, cancellable=true)
    public void addInject(CompoundTag pCompound, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag tag = Atda.serializeAll(this);
        pCompound.m_128365_("refraction_reserved_atda", (Tag)tag);
        cir.setReturnValue((Object)pCompound);
    }

    @Inject(at={@At(value="RETURN")}, method={"load"})
    public void loadInject(CompoundTag pCompound, CallbackInfo ci) {
        Atda.deserializeAll(this, pCompound);
    }

    @Inject(at={@At(value="RETURN")}, method={"tick"})
    public void tick(CallbackInfo ci) {
        Atda.tickProviders(this);
    }

    @Override
    public <C, D extends IAtdaProvider> void addData(Atda<C, ?> registry, D providers) {
        if (registry == null) {
            throw new UnsupportedOperationException("Registry can't be null");
        }
        if (providers == null) {
            throw new UnsupportedOperationException("Provider can't be null");
        }
        registry.add(this, providers);
    }

    @Override
    @NotNull
    public <O, D extends AtdaData<D>> Optional<D> getAtda(Atda<O, D> holder) {
        return Atda.get(holder, this);
    }

    @Override
    public String getSyncID() {
        return "" + this.m_19879_();
    }

    @Override
    public Level getLevel() {
        return this.m_9236_();
    }
}

