/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.mixin;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.ProgressListener;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.refractionapi.refraction.events.RefractionEvents;
import net.refractionapi.refraction.feature.atda.Atda;
import net.refractionapi.refraction.feature.atda.AtdaData;
import net.refractionapi.refraction.feature.atda.IAtdaProvider;
import net.refractionapi.refraction.helper.misc.TagIO;
import net.refractionapi.refraction.mixininterfaces.ILevel;
import net.refractionapi.refraction.util.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin
implements ILevel {
    private LevelResource resource = FileUtil.createResource("atda");
    private TagIO tagIO;

    @Shadow
    @Nonnull
    public abstract MinecraftServer m_7654_();

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void initServer(MinecraftServer server, Executor dispatcher, LevelStorageSource.LevelStorageAccess levelStorageAccess, ServerLevelData serverLevelData, ResourceKey dimension, LevelStem levelStem, ChunkProgressListener progressListener, boolean isDebug, long biomeZoomSeed, List customSpawners, boolean tickTime, RandomSequences randomSequences, CallbackInfo ci) {
        RefractionEvents.REGISTER_ATDA.invoker().register(this);
    }

    @Inject(at={@At(value="TAIL")}, method={"save"})
    public void save(ProgressListener progress, boolean flush, boolean skipSave, CallbackInfo ci) {
    }

    @Override
    public <C, D extends IAtdaProvider> void addData(Atda<C, ?> registry, D providers) {
        if (registry == null) {
            throw new UnsupportedOperationException("Registry can't be null");
        }
        if (providers == null) {
            throw new UnsupportedOperationException("Provider can't be null");
        }
        registry.add(this, providers);
    }

    @Override
    @NotNull
    public <O, D extends AtdaData<D>> Optional<D> getAtda(Atda<O, D> holder) {
        return Atda.get(holder, this);
    }

    @Override
    public String getSyncID() {
        return "";
    }

    @Override
    public Level getLevel() {
        return (Level)this;
    }

    public TagIO getIO() {
        this.tagIO = this.tagIO == null ? new TagIO(this.m_7654_().m_129843_(this.resource).toString()) : this.tagIO;
        return this.tagIO;
    }
}

