/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.networking.C2S;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.refractionapi.refraction.Refraction;
import net.refractionapi.refraction.data.RefractionData;
import net.refractionapi.refraction.feature.screen.RefractionScreen;
import net.refractionapi.refraction.feature.screen.ScreenBuilder;
import net.refractionapi.refraction.feature.screen.ServerScreen;
import net.refractionapi.refraction.networking.Packet;
import org.jetbrains.annotations.Nullable;

public class SendScreenDataC2SPacket
extends Packet {
    private final RefractionScreen.Code code;
    private final CompoundTag tag;

    public SendScreenDataC2SPacket(RefractionScreen.Code code, CompoundTag tag) {
        this.code = code;
        this.tag = tag;
    }

    public SendScreenDataC2SPacket(RefractionScreen.Code code) {
        this(code, new CompoundTag());
    }

    public SendScreenDataC2SPacket(CompoundTag tag) {
        this(RefractionScreen.Code.DATA, tag);
    }

    public SendScreenDataC2SPacket(FriendlyByteBuf buf) {
        this.code = RefractionScreen.Code.values()[buf.m_130242_()];
        this.tag = buf.m_130260_();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.code.ordinal());
        buf.m_130079_(this.tag);
    }

    @Override
    public void handle(@Nullable Player player, Consumer<Runnable> context) {
        context.accept(() -> {
            if (player instanceof ServerPlayer) {
                Optional<ServerScreen> screen = RefractionData.get(player).getScreen();
                if (this.code.equals((Object)RefractionScreen.Code.OPEN)) {
                    ScreenBuilder builder = ScreenBuilder.get(this.tag);
                    if (builder == null || !builder.clientAccessible()) {
                        return;
                    }
                    Object[] args = builder.deserialize(this.tag);
                    screen.ifPresentOrElse(serverScreen -> {
                        if (serverScreen.canClose()) {
                            builder.setScreen(player, args);
                        }
                    }, () -> builder.setScreen(player, args));
                }
                screen.ifPresent(serverScreen -> {
                    switch (this.code) {
                        case CLOSE: {
                            if (!serverScreen.canClose()) break;
                            serverScreen.close();
                            break;
                        }
                        case DATA: {
                            serverScreen.handle(this.tag);
                            break;
                        }
                        default: {
                            Refraction.LOGGER.warn("Invalid screen handle request : {}", (Object)player.m_7755_().getString());
                        }
                    }
                });
            }
        });
    }
}

