/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.networking;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.refractionapi.refraction.client.ClientData;
import net.refractionapi.refraction.networking.Packet;
import net.refractionapi.refraction.networking.RefractionMessages;

public class RefractionMessagesForge
implements RefractionMessages {
    private static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("refraction", "messages")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
    private static int packetId = 0;

    private static int id() {
        return packetId++;
    }

    @Override
    public <P extends Packet> void register(Class<P> msgClass, RefractionMessages.RNetworkDirection direction) {
        INSTANCE.messageBuilder(msgClass, RefractionMessagesForge.id(), direction == RefractionMessages.RNetworkDirection.PLAY_TO_CLIENT ? NetworkDirection.PLAY_TO_CLIENT : NetworkDirection.PLAY_TO_SERVER).decoder(byteBuf -> {
            try {
                return (Packet)msgClass.getConstructor(FriendlyByteBuf.class).newInstance(byteBuf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).encoder(Packet::write).consumerMainThread((msg, supplier) -> msg.handle((Player)(((NetworkEvent.Context)supplier.get()).getSender() == null ? ClientData.getPlayer() : ((NetworkEvent.Context)supplier.get()).getSender()), arg_0 -> RefractionMessagesForge.lambda$register$4((Supplier)supplier, arg_0))).add();
    }

    @Override
    public <MSG extends Packet> void sendServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    @Override
    public <MSG extends Packet> void sendAll(MSG message, Level level) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), message);
    }

    @Override
    public <MSG extends Packet> void sendPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    @Override
    public <MSG extends Packet> void sendAllTracking(MSG message, LivingEntity player) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), message);
    }

    private static /* synthetic */ void lambda$register$4(Supplier supplier, Runnable c) {
        ((NetworkEvent.Context)supplier.get()).enqueueWork(c);
    }
}

