/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.networking.S2C;

import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.refractionapi.refraction.client.ClientData;
import net.refractionapi.refraction.feature.sound.TickableSoundRegistry;
import net.refractionapi.refraction.networking.Packet;
import org.jetbrains.annotations.Nullable;

public class AttachTickableSoundS2CPacket
extends Packet {
    private final String sound;
    private final LivingEntity livingEntity;
    private final CompoundTag serialized;
    private final String cachedName;

    public AttachTickableSoundS2CPacket(String sound, LivingEntity livingEntity, CompoundTag serialized, String cachedName) {
        this.sound = sound;
        this.livingEntity = livingEntity;
        this.serialized = serialized;
        this.cachedName = cachedName;
    }

    public AttachTickableSoundS2CPacket(FriendlyByteBuf buf) {
        this.sound = buf.m_130277_();
        this.livingEntity = ClientData.getEntity(buf.readInt());
        this.serialized = buf.m_130260_();
        this.cachedName = buf.m_130277_();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.sound);
        buf.writeInt(this.livingEntity.m_19879_());
        buf.m_130079_(this.serialized);
        buf.m_130070_(this.cachedName);
    }

    @Override
    public void handle(@Nullable Player player, Consumer<Runnable> context) {
        context.accept(() -> TickableSoundRegistry.attach(this.sound, this.livingEntity, this.serialized, this.cachedName));
    }
}

