/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.networking.S2C;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.refractionapi.refraction.feature.quest.client.ClientQuestInfo;
import net.refractionapi.refraction.networking.Packet;
import org.jetbrains.annotations.Nullable;

public class SyncQuestInfoS2CPacket
extends Packet {
    private final boolean inQuest;
    private final Component questName;
    private final Component description;
    private final List<Component> partDescription;
    private final CompoundTag tag;

    public SyncQuestInfoS2CPacket(boolean inQuest, Component questName, Component description, List<Component> partDescription, CompoundTag tag) {
        this.inQuest = inQuest;
        this.questName = questName;
        this.description = description;
        this.partDescription = partDescription;
        this.tag = tag;
    }

    public SyncQuestInfoS2CPacket(FriendlyByteBuf buf) {
        this.inQuest = buf.readBoolean();
        this.questName = buf.m_130238_();
        this.description = buf.m_130238_();
        this.partDescription = buf.m_236845_(FriendlyByteBuf::m_130238_);
        this.tag = buf.m_130260_();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.inQuest);
        buf.m_130083_(this.questName);
        buf.m_130083_(this.description);
        buf.m_236828_(this.partDescription, FriendlyByteBuf::m_130083_);
        buf.m_130079_(this.tag);
    }

    @Override
    public void handle(@Nullable Player player, Consumer<Runnable> context) {
        context.accept(() -> ClientQuestInfo.setQuestInfo(this.inQuest, this.questName, this.description, this.partDescription, this.tag));
    }
}

