/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.networking.S2C;

import io.netty.buffer.Unpooled;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.refractionapi.refraction.client.ClientData;
import net.refractionapi.refraction.feature.channel.TwoWayIntermediary;
import net.refractionapi.refraction.networking.Packet;
import org.jetbrains.annotations.Nullable;

public class TwoWayS2CPacket
extends Packet {
    private final UUID uuid;
    private final FriendlyByteBuf header;
    private final FriendlyByteBuf buf;

    public TwoWayS2CPacket(UUID uuid, FriendlyByteBuf header, FriendlyByteBuf buf) {
        this.uuid = uuid;
        this.header = header;
        this.buf = buf;
    }

    public TwoWayS2CPacket(FriendlyByteBuf buf) {
        this.uuid = buf.m_130259_();
        this.header = new FriendlyByteBuf(Unpooled.copiedBuffer((byte[])buf.m_130052_()));
        this.buf = new FriendlyByteBuf(Unpooled.copiedBuffer((byte[])buf.m_130052_()));
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
        buf.m_130087_(this.header.array());
        buf.m_130087_(this.buf.array());
    }

    @Override
    public void handle(@Nullable Player player, Consumer<Runnable> context) {
        context.accept(() -> {
            if (player == null) {
                return;
            }
            TwoWayIntermediary.instance(false).read(ClientData.getPlayer(), this.uuid, this.header, this.buf);
        });
    }
}

