/*
 * Decompiled with CFR 0.152.
 */
package net.refractionapi.refraction.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.storage.LevelResource;
import net.refractionapi.refraction.Refraction;

public class FileUtil {
    public static String getExtension(String path) {
        int i = path.lastIndexOf(46);
        return i > 0 ? path.substring(i + 1) : "";
    }

    public static String getName(String path) {
        int i = path.lastIndexOf(47);
        return i > 0 ? path.substring(i + 1) : path;
    }

    public static String getFileName(String path) {
        int i = path.lastIndexOf(47);
        int j = path.lastIndexOf(46);
        return i > 0 ? path.substring(i + 1, j) : path.substring(0, j);
    }

    public static String getDirectory(String path) {
        int i = path.lastIndexOf(47);
        return i > 0 ? path.substring(0, i) : "";
    }

    public static String wrapDirectory(String path) {
        return "./%s".formatted(path);
    }

    public static String[] getFiles(String path) {
        return Path.of(new File(path).getAbsolutePath(), new String[0]).toFile().list();
    }

    public static boolean createPath(String path) {
        Path p = Path.of(new File(path).getAbsolutePath(), new String[0]);
        return p.toFile().exists() || p.toFile().mkdirs();
    }

    public static boolean deleteFile(String path) {
        return Path.of(new File(path).getAbsolutePath(), new String[0]).toFile().delete();
    }

    public static boolean exists(String path) {
        return Path.of(new File(path).getAbsolutePath(), new String[0]).toFile().exists();
    }

    public static LevelResource createResource(String name) {
        try {
            return (LevelResource)LevelResource.class.getDeclaredConstructor(String.class).newInstance(name);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to create LevelResource %s directory!".formatted(name), e);
        }
    }

    public static boolean createIfNotPresent(String path) {
        return FileUtil.exists(path) || FileUtil.saveCompound(path, new CompoundTag());
    }

    public static String defaultDir(String path) {
        return FileUtil.getDirectory(FileUtil.wrapDirectory(path));
    }

    public static boolean saveCompound(String path, CompoundTag tag) {
        if (!FileUtil.createPath(FileUtil.defaultDir(path))) {
            Refraction.LOGGER.error("Failed to create path {}", (Object)FileUtil.getDirectory(path));
            return false;
        }
        try {
            NbtIo.m_128955_((CompoundTag)tag, (File)new File(FileUtil.wrapDirectory(path)));
            return true;
        }
        catch (IOException e) {
            Refraction.LOGGER.error("Failed to save compound to {}", (Object)path, (Object)e);
            return false;
        }
    }

    public static CompoundTag loadCompound(String path) {
        if (!FileUtil.createPath(FileUtil.defaultDir(path))) {
            Refraction.LOGGER.error("Failed to load path {}", (Object)FileUtil.getDirectory(path));
            return null;
        }
        try {
            if (!FileUtil.createIfNotPresent(path)) {
                throw new IOException("invalid directory");
            }
            return NbtIo.m_128953_((File)new File(FileUtil.wrapDirectory(path)));
        }
        catch (IOException e) {
            Refraction.LOGGER.error("Failed to load compound from {}", (Object)path, (Object)e);
            return null;
        }
    }
}

