/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.io.ultimatetreefeller;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.godlycow.io.ultimatetreefeller.UltimateTreeFeller;
import net.godlycow.io.ultimatetreefeller.lib.bstats.bukkit.Metrics;
import net.godlycow.io.ultimatetreefeller.lib.bstats.charts.AdvancedPie;
import net.godlycow.io.ultimatetreefeller.lib.bstats.charts.SimplePie;
import net.godlycow.io.ultimatetreefeller.lib.bstats.charts.SingleLineChart;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MetricsHandler {
    private final UltimateTreeFeller main;
    private final Metrics metrics;
    private int totalTrees = 0;
    private int totalLogs = 0;
    private final Map<UUID, Integer> playerTrees = new ConcurrentHashMap<UUID, Integer>();
    private final Map<String, Integer> worldLogs = new ConcurrentHashMap<String, Integer>();

    public MetricsHandler(JavaPlugin plugin, UltimateTreeFeller main) {
        this.main = main;
        this.metrics = new Metrics(plugin, 27803);
        this.setupCharts();
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, this::syncFromMain, 1200L, 6000L);
    }

    public synchronized void incrementTree() {
        ++this.totalTrees;
    }

    public synchronized void incrementLog(int count) {
        this.totalLogs += count;
    }

    private synchronized void syncFromMain() {
        this.totalTrees = this.main.getStatsTrees().values().stream().mapToInt(Integer::intValue).sum();
        this.totalLogs = this.main.getStatsLogs().values().stream().mapToInt(Integer::intValue).sum();
        this.playerTrees.clear();
        this.playerTrees.putAll(this.main.getStatsTrees());
        this.worldLogs.clear();
        Bukkit.getWorlds().forEach(world -> {
            int total = this.main.getStatsLogs().values().stream().mapToInt(Integer::intValue).sum();
            if (total > 0) {
                this.worldLogs.put(world.getName(), total);
            }
        });
    }

    private void setupCharts() {
        this.metrics.addCustomChart(new SingleLineChart("total_trees_felled", () -> this.totalTrees));
        this.metrics.addCustomChart(new SingleLineChart("total_logs_broken", () -> this.totalLogs));
        this.metrics.addCustomChart(new SingleLineChart("total_blocks_broken", () -> this.totalLogs + this.totalTrees * 20));
        this.metrics.addCustomChart(new SingleLineChart("average_logs_per_tree", () -> this.totalTrees > 0 ? this.totalLogs / this.totalTrees : 0));
        this.metrics.addCustomChart(new SimplePie("players_used", () -> String.valueOf(this.main.getStatsTrees().size())));
        this.metrics.addCustomChart(new AdvancedPie("treefeller_toggle_state", () -> {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            int on = 0;
            int off = 0;
            for (boolean state : this.main.getToggles().values()) {
                if (state) {
                    ++on;
                    continue;
                }
                ++off;
            }
            map.put("Enabled", on);
            map.put("Disabled", off);
            return map;
        }));
        this.metrics.addCustomChart(new SimplePie("instant_mode_enabled", () -> this.main.getConfig().getBoolean("instant-mode", false) ? "Enabled" : "Disabled"));
        this.metrics.addCustomChart(new SimplePie("replant_enabled", () -> this.main.getConfig().getDouble("replant-chance", 0.5) > 0.0 ? "Enabled" : "Disabled"));
        this.metrics.addCustomChart(new AdvancedPie("active_worlds", () -> {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            if (this.worldLogs.isEmpty()) {
                return map;
            }
            for (Map.Entry<String, Integer> entry : this.worldLogs.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
            return map;
        }));
        this.metrics.addCustomChart(new AdvancedPie("top_players_trees_cut", () -> {
            LinkedHashMap map = new LinkedHashMap();
            this.main.getStatsTrees().entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(5L).forEach(entry -> {
                String name = Bukkit.getOfflinePlayer((UUID)((UUID)entry.getKey())).getName();
                map.put(name != null ? name : "Unknown", (Integer)entry.getValue());
            });
            return map;
        }));
    }
}

