/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.io.ultimatetreefeller;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.JsonNode;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.ObjectMapper;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ModrinthUpdateChecker {
    private final JavaPlugin plugin;
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private String projectId;
    private String currentVersion;
    private long checkInterval;
    private boolean notifyOpsOnly;
    private String latestVersion = null;
    private Instant lastCheck = Instant.now().minusSeconds(3600L);
    private final Set<String> recentNotifications = new HashSet<String>();

    public ModrinthUpdateChecker(JavaPlugin plugin, FileConfiguration config) {
        this.plugin = plugin;
        this.loadConfig(config);
        this.startPeriodicCheck();
    }

    private void loadConfig(FileConfiguration config) {
        this.projectId = config.getString("modrinth.project-id", "");
        this.currentVersion = config.getString("modrinth.current-version", "");
        this.checkInterval = TimeUnit.MINUTES.toMillis(config.getLong("modrinth.check-interval-minutes", 30L));
        this.notifyOpsOnly = config.getBoolean("modrinth.notify-ops-only", true);
        if (this.projectId.isEmpty() || this.currentVersion.isEmpty()) {
            this.plugin.getLogger().warning("[UltimateTreeFeller] Modrinth config incomplete \u2013 update checker disabled.");
        }
    }

    public void checkOnJoin(Player player) {
        if (this.shouldCheck()) {
            this.fetchLatestVersion();
        }
        if (this.hasUpdate() && !this.recentNotifications.contains(this.latestVersion)) {
            this.notifyOps(this.latestVersion);
            this.recentNotifications.add(this.latestVersion);
        }
    }

    private boolean shouldCheck() {
        return Instant.now().toEpochMilli() - this.lastCheck.toEpochMilli() > this.checkInterval;
    }

    private void fetchLatestVersion() {
        if (this.projectId.isEmpty()) {
            return;
        }
        CompletableFuture.supplyAsync(() -> {
            try {
                URL url = new URL("https://api.modrinth.com/v2/project/" + this.projectId + "/version?loaders=[\"paper\"]");
                HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                int responseCode = conn.getResponseCode();
                if (responseCode == 200) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    reader.close();
                    JsonNode root = this.objectMapper.readTree(response.toString());
                    if (root.isArray() && root.size() > 0) {
                        this.latestVersion = root.get(0).get("version_number").asText();
                        this.lastCheck = Instant.now();
                        this.plugin.getLogger().info("[UltimateTreeFeller] Latest version: " + this.latestVersion);
                        return true;
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("[UltimateTreeFeller] Failed to check Modrinth: " + e.getMessage());
            }
            return false;
        }).thenRun(() -> {
            if (this.hasUpdate() && !this.recentNotifications.contains(this.latestVersion)) {
                this.notifyOps(this.latestVersion);
                this.recentNotifications.add(this.latestVersion);
            }
        });
    }

    private boolean hasUpdate() {
        if (this.latestVersion == null) {
            return false;
        }
        String[] currentParts = this.currentVersion.split("\\.");
        String[] latestParts = this.latestVersion.split("\\.");
        for (int i = 0; i < Math.min(currentParts.length, latestParts.length); ++i) {
            int c = Integer.parseInt(currentParts[i]);
            int l = Integer.parseInt(latestParts[i]);
            if (l > c) {
                return true;
            }
            if (l >= c) continue;
            return false;
        }
        return latestParts.length > currentParts.length;
    }

    private void notifyOps(String newVersion) {
        String projectSlug = this.projectId;
        String link = "https://modrinth.com/plugin/" + projectSlug;
        String tooltip = "Click to update on Modrinth!";
        Component hoverComp = Component.text((String)tooltip).clickEvent(ClickEvent.openUrl((String)link));
        String message = this.plugin.getConfig().getString("messages.update-available", "<red>Update available!</red>");
        this.mm.deserialize(message, new TagResolver[]{Placeholder.unparsed((String)"project", (String)"UltimateTreeFeller"), Placeholder.unparsed((String)"current", (String)this.currentVersion), Placeholder.unparsed((String)"latest", (String)newVersion), Placeholder.component((String)"link", (ComponentLike)Component.text((String)link).clickEvent(ClickEvent.openUrl((String)link))), Placeholder.component((String)"tooltip", (ComponentLike)hoverComp)});
        for (Player op : Bukkit.getOnlinePlayers()) {
            if (this.notifyOpsOnly && !op.isOp()) continue;
            op.sendMessage(this.mm.deserialize(message, new TagResolver[]{Placeholder.unparsed((String)"project", (String)"UltimateTreeFeller"), Placeholder.unparsed((String)"current", (String)this.currentVersion), Placeholder.unparsed((String)"latest", (String)newVersion), Placeholder.component((String)"link", (ComponentLike)Component.text((String)link).clickEvent(ClickEvent.openUrl((String)link))), Placeholder.component((String)"tooltip", (ComponentLike)hoverComp)}));
        }
    }

    private void startPeriodicCheck() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::fetchLatestVersion, 20L, this.checkInterval / 50L);
    }

    public void reload(FileConfiguration config) {
        this.recentNotifications.clear();
        this.loadConfig(config);
        this.fetchLatestVersion();
    }
}

