/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.io.ultimatetreefeller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.godlycow.io.ultimatetreefeller.MetricsHandler;
import net.godlycow.io.ultimatetreefeller.ModrinthUpdateChecker;
import net.godlycow.io.ultimatetreefeller.PAPIExpansion;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UltimateTreeFeller
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final Map<UUID, Boolean> toggled = new HashMap<UUID, Boolean>();
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final Map<UUID, Integer> statsTrees = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> statsLogs = new HashMap<UUID, Integer>();
    private ModrinthUpdateChecker updateChecker;
    private MetricsHandler metricsHandler;
    private final NamespacedKey TOGGLE_KEY = new NamespacedKey((Plugin)this, "toggle");
    private final NamespacedKey TREES_KEY = new NamespacedKey((Plugin)this, "trees");
    private final NamespacedKey LOGS_KEY = new NamespacedKey((Plugin)this, "logs");
    private Set<Material> LOGS;
    private Set<Material> LEAVES;
    private Set<Material> AXES;
    private List<String> ALLOWED_WORLDS;
    private int MAX_SIZE;
    private long COOLDOWN;
    private boolean INSTANT;
    private int DELAY;
    private double REPLANT;
    private int DAMAGE_PER_LOG;

    public Map<UUID, Integer> getStatsTrees() {
        return this.statsTrees;
    }

    public Map<UUID, Integer> getStatsLogs() {
        return this.statsLogs;
    }

    public Map<UUID, Boolean> getToggles() {
        return this.toggled;
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.loadConfigValues();
        this.updateChecker = new ModrinthUpdateChecker(this, this.config);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PAPIExpansion(this).register();
        }
        this.loadPlayerData();
        this.metricsHandler = new MetricsHandler(this, this);
        this.startCooldownTask();
    }

    public void onDisable() {
        this.savePlayerData();
    }

    private void loadConfigValues() {
        this.LOGS = new HashSet<Material>(Arrays.asList(Material.OAK_LOG, Material.BIRCH_LOG, Material.SPRUCE_LOG, Material.JUNGLE_LOG, Material.ACACIA_LOG, Material.DARK_OAK_LOG, Material.MANGROVE_LOG, Material.CHERRY_LOG, Material.STRIPPED_OAK_LOG, Material.STRIPPED_BIRCH_LOG, Material.STRIPPED_SPRUCE_LOG, Material.STRIPPED_JUNGLE_LOG, Material.STRIPPED_ACACIA_LOG, Material.STRIPPED_DARK_OAK_LOG, Material.STRIPPED_MANGROVE_LOG, Material.STRIPPED_CHERRY_LOG));
        this.LEAVES = new HashSet<Material>(Arrays.asList(Material.OAK_LEAVES, Material.BIRCH_LEAVES, Material.SPRUCE_LEAVES, Material.JUNGLE_LEAVES, Material.ACACIA_LEAVES, Material.DARK_OAK_LEAVES, Material.MANGROVE_LEAVES, Material.CHERRY_LEAVES, Material.AZALEA_LEAVES, Material.FLOWERING_AZALEA_LEAVES));
        this.AXES = new HashSet<Material>(Arrays.asList(Material.WOODEN_AXE, Material.STONE_AXE, Material.IRON_AXE, Material.GOLDEN_AXE, Material.DIAMOND_AXE, Material.NETHERITE_AXE));
        this.ALLOWED_WORLDS = this.config.getStringList("allowed-worlds");
        this.MAX_SIZE = this.config.getInt("max-tree-size", 500);
        this.COOLDOWN = this.config.getLong("cooldown-seconds", 5L) * 1000L;
        this.INSTANT = this.config.getBoolean("instant-mode", false);
        this.DELAY = this.config.getInt("animation-delay-ticks", 2);
        this.REPLANT = this.config.getDouble("replant-chance", 0.5);
        this.DAMAGE_PER_LOG = this.config.getInt("tool-damage-per-log", 1);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.isOp()) {
            this.updateChecker.checkOnJoin(player);
        }
    }

    private void loadPlayerData() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            PersistentDataContainer pdc = p.getPersistentDataContainer();
            this.toggled.put(p.getUniqueId(), (Boolean)pdc.getOrDefault(this.TOGGLE_KEY, PersistentDataType.BOOLEAN, (Object)true));
            this.statsTrees.put(p.getUniqueId(), (Integer)pdc.getOrDefault(this.TREES_KEY, PersistentDataType.INTEGER, (Object)0));
            this.statsLogs.put(p.getUniqueId(), (Integer)pdc.getOrDefault(this.LOGS_KEY, PersistentDataType.INTEGER, (Object)0));
        }
    }

    private void savePlayerData() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            PersistentDataContainer pdc = p.getPersistentDataContainer();
            UUID id = p.getUniqueId();
            pdc.set(this.TOGGLE_KEY, PersistentDataType.BOOLEAN, (Object)this.toggled.getOrDefault(id, true));
            pdc.set(this.TREES_KEY, PersistentDataType.INTEGER, (Object)this.statsTrees.getOrDefault(id, 0));
            pdc.set(this.LOGS_KEY, PersistentDataType.INTEGER, (Object)this.statsLogs.getOrDefault(id, 0));
        }
    }

    private void startCooldownTask() {
        new BukkitRunnable(){

            public void run() {
                long now = System.currentTimeMillis();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    Long end = UltimateTreeFeller.this.cooldowns.get(p.getUniqueId());
                    if (end == null || end <= now) continue;
                    long remaining = (end - now) / 1000L;
                    UltimateTreeFeller.this.sendActionBar(p, UltimateTreeFeller.this.config.getString("messages.cooldown.actionbar", "<red>Cooldown: <time>s</red>"), new TagResolver[]{Placeholder.unparsed((String)"time", (String)String.valueOf(remaining))});
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 5L);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        Block b = e.getBlock();
        ItemStack tool = p.getInventory().getItemInMainHand();
        if (!this.isEnabled(p) || !this.hasPerm(p, "ultimatetreefeller.use")) {
            return;
        }
        if (!this.AXES.contains(tool.getType())) {
            return;
        }
        if (!this.LOGS.contains(b.getType())) {
            return;
        }
        if (!this.isBottomLog(b)) {
            return;
        }
        if (!this.ALLOWED_WORLDS.isEmpty() && !this.ALLOWED_WORLDS.contains(b.getWorld().getName())) {
            return;
        }
        long now = System.currentTimeMillis();
        Long cooldownEnd = this.cooldowns.get(p.getUniqueId());
        if (cooldownEnd != null && cooldownEnd > now && !this.hasPerm(p, "ultimatetreefeller.bypasscooldown")) {
            long secs = (cooldownEnd - now) / 1000L;
            this.sendMessage(p, "messages.cooldown.chat", new TagResolver[]{Placeholder.unparsed((String)"time", (String)String.valueOf(secs))});
            e.setCancelled(true);
            return;
        }
        Set<Block> logs = this.findTree(b);
        Set<Block> leaves = this.findLeaves(logs);
        int total = logs.size() + leaves.size();
        if (total > this.MAX_SIZE) {
            this.sendMessage(p, "messages.too-large", new TagResolver[]{Placeholder.unparsed((String)"max", (String)String.valueOf(this.MAX_SIZE))});
            return;
        }
        e.setCancelled(true);
        this.cooldowns.put(p.getUniqueId(), now + this.COOLDOWN);
        this.updateStats(p, 1, logs.size());
        if (this.INSTANT) {
            this.breakInstant(p, logs, leaves, tool);
        } else {
            this.animateFelling(p, logs, leaves, tool);
        }
        if (ThreadLocalRandom.current().nextDouble() < this.REPLANT) {
            this.replantSapling(b);
            this.sendMessage(p, "messages.replanted", new TagResolver[0]);
        }
        this.sendMessage(p, "messages.tree-felled", new TagResolver[]{Placeholder.unparsed((String)"logs", (String)String.valueOf(logs.size())), Placeholder.unparsed((String)"leaves", (String)String.valueOf(leaves.size()))});
    }

    private void sendMessage(Player p, String path, TagResolver ... resolvers) {
        String msg = this.config.getString(path);
        if (msg != null && !msg.isEmpty()) {
            p.sendMessage(this.mm.deserialize(msg, resolvers));
        }
    }

    private void sendActionBar(Player p, String msg, TagResolver ... resolvers) {
        p.sendActionBar(this.mm.deserialize(msg, resolvers));
    }

    private void updateBossBar(BossBar bar, float progress, String template) {
        int percent = (int)(progress * 100.0f);
        bar.name(this.mm.deserialize(template, (TagResolver)Placeholder.unparsed((String)"progress", (String)(percent + "%"))));
        bar.progress(progress);
    }

    private Set<Block> findTree(Block start) {
        HashSet<Block> logs = new HashSet<Block>();
        LinkedList<Block> q = new LinkedList<Block>();
        q.add(start);
        Material type = start.getType();
        while (!q.isEmpty() && logs.size() < this.MAX_SIZE) {
            Block cur = (Block)q.poll();
            if (logs.contains(cur) || !this.LOGS.contains(cur.getType()) || cur.getType() != type && !this.isStripped(type, cur.getType())) continue;
            logs.add(cur);
            for (BlockFace f : BlockFace.values()) {
                if (f == BlockFace.SELF) continue;
                q.add(cur.getRelative(f));
            }
        }
        return logs;
    }

    private boolean isStripped(Material original, Material stripped) {
        return stripped.name().equals("STRIPPED_" + original.name());
    }

    private Set<Block> findLeaves(Set<Block> logs) {
        HashSet<Block> leaves = new HashSet<Block>();
        for (Block log : logs) {
            for (int x = -3; x <= 3; ++x) {
                for (int y = -3; y <= 3; ++y) {
                    for (int z = -3; z <= 3; ++z) {
                        Block r = log.getRelative(x, y, z);
                        if (!this.LEAVES.contains(r.getType())) continue;
                        leaves.add(r);
                    }
                }
            }
        }
        return leaves;
    }

    private void breakInstant(Player p, Set<Block> logs, Set<Block> leaves, ItemStack tool) {
        for (Block b : logs) {
            this.damageTool(tool, this.DAMAGE_PER_LOG);
            b.breakNaturally(tool);
        }
        for (Block b : leaves) {
            b.breakNaturally(tool);
        }
    }

    private void animateFelling(final Player p, Set<Block> logs, Set<Block> leaves, final ItemStack tool) {
        final ArrayList<Block> logList = new ArrayList<Block>(logs);
        final ArrayList<Block> leafList = new ArrayList<Block>(leaves);
        final BossBar logBar = BossBar.bossBar((Component)Component.text((String)""), (float)0.0f, (BossBar.Color)BossBar.Color.GREEN, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
        final BossBar leafBar = BossBar.bossBar((Component)Component.text((String)""), (float)0.0f, (BossBar.Color)BossBar.Color.YELLOW, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
        p.showBossBar(logBar);
        if (!leaves.isEmpty()) {
            p.showBossBar(leafBar);
        }
        new BukkitRunnable(){
            int i = 0;

            public void run() {
                if (this.i < logList.size()) {
                    Block b = (Block)logList.get(this.i);
                    UltimateTreeFeller.this.damageTool(tool, UltimateTreeFeller.this.DAMAGE_PER_LOG);
                    b.breakNaturally(tool);
                    p.playSound(b.getLocation(), Sound.BLOCK_WOOD_BREAK, 1.0f, 1.0f);
                    b.getWorld().spawnParticle(Particle.BLOCK, b.getLocation().add(0.5, 0.5, 0.5), 15, 0.3, 0.3, 0.3, 0.0, (Object)b.getBlockData());
                    UltimateTreeFeller.this.updateBossBar(logBar, (float)(this.i + 1) / (float)logList.size(), UltimateTreeFeller.this.config.getString("messages.bossbar-logs", "Chopping... <progress>%"));
                    ++this.i;
                } else {
                    p.hideBossBar(logBar);
                    UltimateTreeFeller.this.animateLeaves(p, leafList, leafBar, tool);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this, 0L, (long)this.DELAY);
    }

    private void animateLeaves(final Player p, final List<Block> leaves, final BossBar bar, final ItemStack tool) {
        new BukkitRunnable(){
            int i = 0;

            public void run() {
                if (this.i < leaves.size()) {
                    Block b = (Block)leaves.get(this.i);
                    b.breakNaturally(tool);
                    p.playSound(b.getLocation(), Sound.BLOCK_GRASS_BREAK, 0.8f, 1.2f);
                    b.getWorld().spawnParticle(Particle.BLOCK, b.getLocation().add(0.5, 0.5, 0.5), 10, 0.2, 0.2, 0.2, 0.0, (Object)b.getBlockData());
                    UltimateTreeFeller.this.updateBossBar(bar, (float)(this.i + 1) / (float)leaves.size(), UltimateTreeFeller.this.config.getString("messages.bossbar-leaves", "Leaves... <progress>%"));
                    ++this.i;
                } else {
                    p.hideBossBar(bar);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this, 0L, (long)this.DELAY);
    }

    private void damageTool(ItemStack tool, int dmg) {
        ItemMeta itemMeta = tool.getItemMeta();
        if (itemMeta instanceof Damageable) {
            Damageable meta = (Damageable)itemMeta;
            int newDmg = meta.getDamage() + dmg;
            if (newDmg >= tool.getType().getMaxDurability()) {
                tool.setAmount(0);
                Bukkit.getOnlinePlayers().forEach(pl -> pl.playSound(pl.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f));
            } else {
                meta.setDamage(newDmg);
                tool.setItemMeta((ItemMeta)meta);
            }
        }
    }

    private void replantSapling(Block base) {
        Material sapling;
        switch (base.getType()) {
            case OAK_LOG: 
            case STRIPPED_OAK_LOG: {
                Material material = Material.OAK_SAPLING;
                break;
            }
            case BIRCH_LOG: 
            case STRIPPED_BIRCH_LOG: {
                Material material = Material.BIRCH_SAPLING;
                break;
            }
            case SPRUCE_LOG: 
            case STRIPPED_SPRUCE_LOG: {
                Material material = Material.SPRUCE_SAPLING;
                break;
            }
            case JUNGLE_LOG: 
            case STRIPPED_JUNGLE_LOG: {
                Material material = Material.JUNGLE_SAPLING;
                break;
            }
            case ACACIA_LOG: 
            case STRIPPED_ACACIA_LOG: {
                Material material = Material.ACACIA_SAPLING;
                break;
            }
            case DARK_OAK_LOG: 
            case STRIPPED_DARK_OAK_LOG: {
                Material material = Material.DARK_OAK_SAPLING;
                break;
            }
            case MANGROVE_LOG: 
            case STRIPPED_MANGROVE_LOG: {
                Material material = Material.MANGROVE_PROPAGULE;
                break;
            }
            case CHERRY_LOG: 
            case STRIPPED_CHERRY_LOG: {
                Material material = Material.CHERRY_SAPLING;
                break;
            }
            default: {
                Material material = sapling = null;
            }
        }
        if (sapling != null) {
            base.getWorld().getBlockAt(base.getLocation()).setType(sapling);
        }
    }

    private boolean isBottomLog(Block b) {
        return !this.LOGS.contains(b.getRelative(BlockFace.DOWN).getType());
    }

    private boolean isEnabled(Player p) {
        return this.toggled.getOrDefault(p.getUniqueId(), true);
    }

    private boolean hasPerm(Player p, String perm) {
        return p.hasPermission(perm);
    }

    private void updateStats(Player p, int trees, int logs) {
        UUID id = p.getUniqueId();
        this.statsTrees.put(id, this.statsTrees.getOrDefault(id, 0) + trees);
        this.statsLogs.put(id, this.statsLogs.getOrDefault(id, 0) + logs);
        if (this.metricsHandler != null) {
            if (trees > 0) {
                this.metricsHandler.incrementTree();
            }
            if (logs > 0) {
                this.metricsHandler.incrementLog(logs);
            }
        }
    }

    public boolean onCommand(CommandSender s, Command cmd, String label, String[] args) {
        if (!(s instanceof Player)) {
            return true;
        }
        Player p = (Player)s;
        if (args.length == 0 || args[0].equalsIgnoreCase("toggle")) {
            boolean state = !this.isEnabled(p);
            this.toggled.put(p.getUniqueId(), state);
            this.sendMessage(p, state ? "messages.toggle-on" : "messages.toggle-off", new TagResolver[0]);
        } else if (args[0].equalsIgnoreCase("reload") && this.hasPerm(p, "ultimatetreefeller.reload")) {
            this.reloadConfig();
            this.config = this.getConfig();
            this.loadConfigValues();
            if (this.updateChecker != null) {
                this.updateChecker.reload(this.config);
            }
            this.sendMessage(p, "messages.reload-success", new TagResolver[0]);
        }
        return true;
    }
}

