/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.io.ultimatetreefeller.lib.jackson.databind.deser.impl;

import java.io.IOException;
import java.io.Serializable;
import net.godlycow.io.ultimatetreefeller.lib.jackson.annotation.ObjectIdGenerator;
import net.godlycow.io.ultimatetreefeller.lib.jackson.annotation.ObjectIdResolver;
import net.godlycow.io.ultimatetreefeller.lib.jackson.core.JsonParser;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.DeserializationContext;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.JavaType;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.JsonDeserializer;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.PropertyName;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.deser.SettableBeanProperty;

public class ObjectIdReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final JavaType _idType;
    public final PropertyName propertyName;
    public final ObjectIdGenerator<?> generator;
    public final ObjectIdResolver resolver;
    protected final JsonDeserializer<Object> _deserializer;
    public final SettableBeanProperty idProperty;

    protected ObjectIdReader(JavaType t, PropertyName propName, ObjectIdGenerator<?> gen, JsonDeserializer<?> deser, SettableBeanProperty idProp, ObjectIdResolver resolver) {
        this._idType = t;
        this.propertyName = propName;
        this.generator = gen;
        this.resolver = resolver;
        this._deserializer = deser;
        this.idProperty = idProp;
    }

    public static ObjectIdReader construct(JavaType idType, PropertyName propName, ObjectIdGenerator<?> generator, JsonDeserializer<?> deser, SettableBeanProperty idProp, ObjectIdResolver resolver) {
        return new ObjectIdReader(idType, propName, generator, deser, idProp, resolver);
    }

    public JsonDeserializer<Object> getDeserializer() {
        return this._deserializer;
    }

    public JavaType getIdType() {
        return this._idType;
    }

    public boolean maySerializeAsObject() {
        return this.generator.maySerializeAsObject();
    }

    public boolean isValidReferencePropertyName(String name, JsonParser parser) {
        return this.generator.isValidReferencePropertyName(name, parser);
    }

    public Object readObjectReference(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this._deserializer.deserialize(jp, ctxt);
    }
}

