/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.io.ultimatetreefeller.lib.jackson.databind.deser.std;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.godlycow.io.ultimatetreefeller.lib.jackson.core.JsonParser;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.DeserializationContext;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.deser.std.StdScalarDeserializer;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.type.LogicalType;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.util.ByteBufferBackedOutputStream;

public class ByteBufferDeserializer
extends StdScalarDeserializer<ByteBuffer> {
    private static final long serialVersionUID = 1L;

    protected ByteBufferDeserializer() {
        super(ByteBuffer.class);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Binary;
    }

    @Override
    public ByteBuffer deserialize(JsonParser parser, DeserializationContext cx) throws IOException {
        byte[] b = parser.getBinaryValue();
        return ByteBuffer.wrap(b);
    }

    @Override
    public ByteBuffer deserialize(JsonParser jp, DeserializationContext ctxt, ByteBuffer intoValue) throws IOException {
        ByteBufferBackedOutputStream out = new ByteBufferBackedOutputStream(intoValue);
        jp.readBinaryValue(ctxt.getBase64Variant(), out);
        out.close();
        return intoValue;
    }
}

