/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.io.ultimatetreefeller.lib.jackson.databind.module;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.BeanDescription;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.DeserializationConfig;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.JavaType;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.JsonDeserializer;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.JsonMappingException;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.JsonNode;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.KeyDeserializer;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.deser.Deserializers;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.jsontype.TypeDeserializer;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.type.ArrayType;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.type.ClassKey;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.type.CollectionLikeType;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.type.CollectionType;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.type.MapLikeType;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.type.MapType;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.type.ReferenceType;

public class SimpleDeserializers
extends Deserializers.Base
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected HashMap<ClassKey, JsonDeserializer<?>> _classMappings = null;
    protected boolean _hasEnumDeserializer = false;

    public SimpleDeserializers() {
    }

    public SimpleDeserializers(Map<Class<?>, JsonDeserializer<?>> desers) {
        this.addDeserializers(desers);
    }

    public <T> void addDeserializer(Class<T> forClass, JsonDeserializer<? extends T> deser) {
        ClassKey key = new ClassKey(forClass);
        if (this._classMappings == null) {
            this._classMappings = new HashMap();
        }
        this._classMappings.put(key, deser);
        if (forClass == Enum.class) {
            this._hasEnumDeserializer = true;
        }
    }

    public void addDeserializers(Map<Class<?>, JsonDeserializer<?>> desers) {
        for (Map.Entry<Class<?>, JsonDeserializer<?>> entry : desers.entrySet()) {
            Class<?> cls = entry.getKey();
            JsonDeserializer<?> deser = entry.getValue();
            this.addDeserializer(cls, deser);
        }
    }

    @Override
    public JsonDeserializer<?> findArrayDeserializer(ArrayType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        return this._find(type);
    }

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        return this._find(type);
    }

    @Override
    public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        return this._find(type);
    }

    @Override
    public JsonDeserializer<?> findCollectionLikeDeserializer(CollectionLikeType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        return this._find(type);
    }

    @Override
    public JsonDeserializer<?> findEnumDeserializer(Class<?> type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (this._classMappings == null) {
            return null;
        }
        JsonDeserializer<?> deser = this._classMappings.get(new ClassKey(type));
        if (deser == null && this._hasEnumDeserializer && type.isEnum()) {
            deser = this._classMappings.get(new ClassKey(Enum.class));
        }
        return deser;
    }

    @Override
    public JsonDeserializer<?> findTreeNodeDeserializer(Class<? extends JsonNode> nodeType, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (this._classMappings == null) {
            return null;
        }
        return this._classMappings.get(new ClassKey(nodeType));
    }

    @Override
    public JsonDeserializer<?> findReferenceDeserializer(ReferenceType refType, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer contentTypeDeserializer, JsonDeserializer<?> contentDeserializer) throws JsonMappingException {
        return this._find(refType);
    }

    @Override
    public JsonDeserializer<?> findMapDeserializer(MapType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        return this._find(type);
    }

    @Override
    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        return this._find(type);
    }

    @Override
    public boolean hasDeserializerFor(DeserializationConfig config, Class<?> valueType) {
        return this._classMappings != null && this._classMappings.containsKey(new ClassKey(valueType));
    }

    private final JsonDeserializer<?> _find(JavaType type) {
        if (this._classMappings == null) {
            return null;
        }
        return this._classMappings.get(new ClassKey(type.getRawClass()));
    }
}

