/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.io.ultimatetreefeller.lib.jackson.databind.ser.impl;

import net.godlycow.io.ultimatetreefeller.lib.jackson.annotation.ObjectIdGenerator;
import net.godlycow.io.ultimatetreefeller.lib.jackson.core.SerializableString;
import net.godlycow.io.ultimatetreefeller.lib.jackson.core.io.SerializedString;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.JavaType;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.JsonSerializer;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.PropertyName;

public final class ObjectIdWriter {
    public final JavaType idType;
    public final SerializableString propertyName;
    public final ObjectIdGenerator<?> generator;
    public final JsonSerializer<Object> serializer;
    public final boolean alwaysAsId;

    protected ObjectIdWriter(JavaType t, SerializableString propName, ObjectIdGenerator<?> gen, JsonSerializer<?> ser, boolean alwaysAsId) {
        this.idType = t;
        this.propertyName = propName;
        this.generator = gen;
        this.serializer = ser;
        this.alwaysAsId = alwaysAsId;
    }

    public static ObjectIdWriter construct(JavaType idType, PropertyName propName, ObjectIdGenerator<?> generator, boolean alwaysAsId) {
        String simpleName = propName == null ? null : propName.getSimpleName();
        SerializedString serName = simpleName == null ? null : new SerializedString(simpleName);
        return new ObjectIdWriter(idType, serName, generator, null, alwaysAsId);
    }

    public ObjectIdWriter withSerializer(JsonSerializer<?> ser) {
        return new ObjectIdWriter(this.idType, this.propertyName, this.generator, ser, this.alwaysAsId);
    }

    public ObjectIdWriter withAlwaysAsId(boolean newState) {
        if (newState == this.alwaysAsId) {
            return this;
        }
        return new ObjectIdWriter(this.idType, this.propertyName, this.generator, this.serializer, newState);
    }
}

