/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.io.ultimatetreefeller.lib.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import net.godlycow.io.ultimatetreefeller.lib.jackson.core.JsonGenerator;
import net.godlycow.io.ultimatetreefeller.lib.jackson.core.JsonToken;
import net.godlycow.io.ultimatetreefeller.lib.jackson.core.type.WritableTypeId;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.JavaType;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.JsonMappingException;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.JsonNode;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.SerializerProvider;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.annotation.JacksonStdImpl;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.jsontype.TypeSerializer;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.node.ObjectNode;
import net.godlycow.io.ultimatetreefeller.lib.jackson.databind.ser.std.StdSerializer;

@JacksonStdImpl
public class ByteArraySerializer
extends StdSerializer<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySerializer() {
        super(byte[].class);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, byte[] value) {
        return value.length == 0;
    }

    @Override
    public void serialize(byte[] value, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
    }

    @Override
    public void serializeWithType(byte[] value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("byte");
        return o.set("items", itemSchema);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

