/*
 * Decompiled with CFR 0.152.
 */
package me.qzwars.lightningsword;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.RayTraceResult;

public class LightningSwordListener
implements Listener {
    private final HashMap<UUID, Long> cooldowns = new HashMap();
    private final long COOLDOWN_MS = 2000L;

    @EventHandler
    public void onSwordUse(PlayerInteractEvent event) {
        if (event.getItem() == null || !event.getItem().hasItemMeta()) {
            return;
        }
        if (!event.getItem().getItemMeta().getDisplayName().equals("\u00a76Lightning Sword")) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        long now = System.currentTimeMillis();
        if (this.cooldowns.containsKey(playerId) && now - this.cooldowns.get(playerId) < 2000L) {
            long secondsLeft = (2000L - (now - this.cooldowns.get(playerId))) / 1000L;
            player.sendMessage("\u23f1 Lightning Sword is on cooldown! Wait " + secondsLeft + "s");
            return;
        }
        this.cooldowns.put(playerId, now);
        Location loc = null;
        RayTraceResult result = player.getWorld().rayTraceEntities(player.getEyeLocation(), player.getLocation().getDirection(), 100.0, e -> e instanceof LivingEntity && e != player);
        if (result != null && result.getHitEntity() != null) {
            LivingEntity target = (LivingEntity)result.getHitEntity();
            loc = target.getLocation();
            loc.getWorld().strikeLightning(loc);
            target.damage(10.0);
        } else if (player.getTargetBlockExact(100) != null) {
            loc = player.getTargetBlockExact(100).getLocation();
            loc.getWorld().strikeLightning(loc);
        }
        if (loc != null) {
            loc.getWorld().spawnParticle(Particle.FLAME, loc, 30, 1.0, 1.0, 1.0, 0.2);
            loc.getWorld().spawnParticle(Particle.CRIT, loc, 30, 1.0, 1.0, 1.0, 0.2);
            loc.getWorld().playSound(loc, Sound.ENTITY_LIGHTNING_BOLT_THUNDER, 1.0f, 1.0f);
        }
    }
}

