/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightblockremove.Block;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.World;
import org.bukkit.plugin.java.JavaPlugin;

public class BlacklistWorld {
    private final JavaPlugin plugin;
    private Set<String> blacklistedWorlds = ConcurrentHashMap.newKeySet();
    private boolean enabled;

    public BlacklistWorld(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    public void loadConfig() {
        this.enabled = this.plugin.getConfig().getBoolean("blacklist-world.enabled", false);
        this.blacklistedWorlds.clear();
        if (this.enabled) {
            for (String worldName : this.plugin.getConfig().getStringList("blacklist-world.worlds")) {
                this.blacklistedWorlds.add(worldName.toLowerCase());
            }
        }
    }

    public boolean isWorldBlacklisted(World world) {
        return this.enabled && this.blacklistedWorlds.contains(world.getName().toLowerCase());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Set<String> getBlacklistedWorlds() {
        return this.blacklistedWorlds;
    }
}

