/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightblockremove.Block;

import dev.atrox.lightblockremove.Block.BlacklistWorld;
import dev.atrox.lightblockremove.HexColor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Display;
import org.bukkit.entity.TextDisplay;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BlockManager {
    private final JavaPlugin plugin;
    private final Map<Block, HologramData> blockData = new ConcurrentHashMap<Block, HologramData>();
    private Set<Material> disabledBlocks = ConcurrentHashMap.newKeySet();
    private Set<String> disabledPlayers = ConcurrentHashMap.newKeySet();
    private BlacklistWorld blacklistWorld;
    private int removeTime;
    private String hologramText;
    private BukkitTask globalTimer;
    private boolean isEnabled;
    private BukkitTask hologramCheckTask;
    private boolean hologramCheckEnabled;
    private int hologramCheckInterval;
    private static final String HOLOGRAM_METADATA_KEY = "LightBlockRemove";

    public BlockManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.blacklistWorld = new BlacklistWorld(plugin);
        this.loadConfig();
        if (this.isEnabled) {
            this.cleanupStaleHolograms();
            this.startOptimizedTimer();
        }
    }

    public void loadConfig() {
        boolean wasEnabled = this.isEnabled;
        this.isEnabled = this.plugin.getConfig().getBoolean("tblockremove.enabled", true);
        if (this.isEnabled != wasEnabled) {
            if (this.isEnabled) {
                this.cleanupStaleHolograms();
                this.startOptimizedTimer();
            } else {
                this.stopTimer();
                this.clearAllBlocks();
            }
        }
        if (!this.isEnabled) {
            return;
        }
        this.removeTime = this.plugin.getConfig().getInt("remove-time", 30);
        this.hologramText = HexColor.translateAlternateColorCodes('&', this.plugin.getConfig().getString("hologram-text", "#9842f5\u26a0 {time}"));
        this.disabledBlocks.clear();
        List disabledBlocksList = this.plugin.getConfig().getStringList("disabled-blocks");
        if (disabledBlocksList != null) {
            disabledBlocksList.forEach(materialName -> {
                Material material = Material.getMaterial((String)materialName.toUpperCase());
                if (material != null) {
                    this.disabledBlocks.add(material);
                }
            });
        }
        this.disabledPlayers.clear();
        List disabledPlayersList = this.plugin.getConfig().getStringList("disabled-players");
        if (disabledPlayersList != null) {
            disabledPlayersList.forEach(playerName -> this.disabledPlayers.add(playerName.toLowerCase()));
        }
        this.blacklistWorld.loadConfig();
        this.hologramCheckEnabled = this.plugin.getConfig().getBoolean("hologram-check-cleanup.enabled", true);
        String intervalString = this.plugin.getConfig().getString("hologram-check-cleanup.interval", "5m");
        this.hologramCheckInterval = this.parseTime(intervalString);
        if (this.hologramCheckEnabled) {
            this.startHologramCheckTask();
        } else {
            this.stopHologramCheckTask();
        }
    }

    private int parseTime(String timeString) {
        if (timeString == null || timeString.isEmpty()) {
            return 300;
        }
        if ((timeString = timeString.toLowerCase()).endsWith("s")) {
            return Integer.parseInt(timeString.substring(0, timeString.length() - 1));
        }
        if (timeString.endsWith("m")) {
            return Integer.parseInt(timeString.substring(0, timeString.length() - 1)) * 60;
        }
        return Integer.parseInt(timeString);
    }

    private void startHologramCheckTask() {
        this.stopHologramCheckTask();
        this.hologramCheckTask = new BukkitRunnable(){

            public void run() {
                new BukkitRunnable(){

                    public void run() {
                        BlockManager.this.cleanupStaleHolograms();
                    }
                }.runTask((Plugin)BlockManager.this.plugin);
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, (long)this.hologramCheckInterval * 20L, (long)this.hologramCheckInterval * 20L);
    }

    private void stopHologramCheckTask() {
        if (this.hologramCheckTask != null) {
            this.hologramCheckTask.cancel();
            this.hologramCheckTask = null;
        }
    }

    private void stopTimer() {
        if (this.globalTimer != null) {
            this.globalTimer.cancel();
            this.globalTimer = null;
        }
    }

    private void removeDisabledBlocks() {
        Iterator<Map.Entry<Block, HologramData>> iterator = this.blockData.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Block, HologramData> entry = iterator.next();
            if (!this.disabledBlocks.contains(entry.getKey().getType())) continue;
            entry.getValue().hologram.remove();
            entry.getKey().setType(Material.AIR);
            iterator.remove();
        }
    }

    public void addBlock(Block block) {
        if (!this.isEnabled || this.disabledBlocks.contains(block.getType()) || this.blacklistWorld.isWorldBlacklisted(block.getWorld())) {
            return;
        }
        this.blockData.entrySet().removeIf(entry -> {
            if (((Block)entry.getKey()).getLocation().equals((Object)block.getLocation())) {
                ((HologramData)entry.getValue()).hologram.remove();
                return true;
            }
            return false;
        });
        Location center = block.getLocation().add(0.5, 0.5, 0.5);
        TextDisplay hologram = (TextDisplay)block.getWorld().spawn(center, TextDisplay.class);
        this.configureHologram(hologram, this.removeTime);
        this.blockData.put(block, new HologramData(hologram, block.getType(), this.removeTime));
    }

    private void configureHologram(TextDisplay hologram, int time) {
        String text = this.hologramText.replace("{time}", String.valueOf(time));
        hologram.setText(HexColor.translateAlternateColorCodes('&', text));
        hologram.setMetadata(HOLOGRAM_METADATA_KEY, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        hologram.setAlignment(TextDisplay.TextAlignment.CENTER);
        hologram.setSeeThrough(true);
        hologram.setShadowed(true);
        hologram.setBackgroundColor(Color.fromARGB((int)0, (int)0, (int)0, (int)0));
        hologram.setBillboard(Display.Billboard.CENTER);
    }

    private void startOptimizedTimer() {
        this.globalTimer = new BukkitRunnable(){

            public void run() {
                long currentTime = System.currentTimeMillis();
                Iterator iterator = BlockManager.this.blockData.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Block block = (Block)entry.getKey();
                    HologramData data = (HologramData)entry.getValue();
                    if (block.getType() != data.originalType || data.hologram.isDead()) {
                        data.hologram.remove();
                        iterator.remove();
                        continue;
                    }
                    long elapsedTime = currentTime - data.lastUpdateTime;
                    if (elapsedTime < 1000L) continue;
                    --data.remainingTime;
                    data.lastUpdateTime = currentTime;
                    if (data.remainingTime <= 0) {
                        BlockManager.this.removeBlock(block, data.hologram);
                        iterator.remove();
                        continue;
                    }
                    BlockManager.this.updateHologramText(data.hologram, data.remainingTime);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void updateHologramText(TextDisplay hologram, int time) {
        String newText = this.hologramText.replace("{time}", String.valueOf(time));
        if (!hologram.getText().equals(newText)) {
            hologram.setText(HexColor.translateAlternateColorCodes('&', newText));
        }
    }

    private void removeBlock(Block block, TextDisplay hologram) {
        block.setType(Material.AIR);
        hologram.remove();
    }

    public void clearAllBlocks() {
        if (!this.isEnabled) {
            return;
        }
        new ArrayList<Block>(this.blockData.keySet()).forEach(block -> {
            HologramData data = this.blockData.get(block);
            if (data != null) {
                data.hologram.remove();
            }
            block.setType(Material.AIR);
        });
        this.blockData.clear();
    }

    public void cleanupStaleHolograms() {
        if (!this.isEnabled) {
            return;
        }
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            for (World world : this.plugin.getServer().getWorlds()) {
                List holograms = world.getEntitiesByClass(TextDisplay.class).stream().filter(h -> h.hasMetadata(HOLOGRAM_METADATA_KEY)).collect(Collectors.toList());
                for (TextDisplay hologram : holograms) {
                    Location hologramLoc = hologram.getLocation();
                    Block block = world.getBlockAt(hologramLoc.getBlockX(), hologramLoc.getBlockY(), hologramLoc.getBlockZ());
                    boolean shouldRemove = block.getType() == Material.AIR || !this.blockData.containsKey(block) || this.disabledBlocks.contains(block.getType()) || !this.isEnabled || this.blacklistWorld.isWorldBlacklisted(world);
                    if (!shouldRemove) continue;
                    hologram.remove();
                    this.blockData.remove(block);
                }
            }
        });
    }

    public void onDisable() {
        this.stopTimer();
        this.stopHologramCheckTask();
        this.clearAllBlocks();
    }

    public Map<Block, HologramData> getBlockData() {
        return this.blockData;
    }

    public boolean isPlayerDisabled(String playerName) {
        return this.disabledPlayers.contains(playerName.toLowerCase());
    }

    public BlacklistWorld getBlacklistWorld() {
        return this.blacklistWorld;
    }

    public static class HologramData {
        public final TextDisplay hologram;
        public final Material originalType;
        public int remainingTime;
        public long lastUpdateTime;

        public HologramData(TextDisplay hologram, Material originalType, int remainingTime) {
            this.hologram = hologram;
            this.originalType = originalType;
            this.remainingTime = remainingTime;
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }
}

