/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightblockremove.Update;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UpdateChecker
implements Listener {
    private final JavaPlugin plugin;
    private final int resourceId;
    private String latestVersion = null;
    private static final long CHECK_INTERVAL = 72000L;
    private final String spigotLink = "https://www.spigotmc.org/resources/lightblockremove.122601/";

    public UpdateChecker(JavaPlugin plugin, int resourceId) {
        this.plugin = plugin;
        this.resourceId = resourceId;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void checkForUpdate() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (InputStream is = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openStream();
                 Scanner scanner = new Scanner(is);){
                if (scanner.hasNext()) {
                    this.latestVersion = scanner.next();
                    String currentVersion = this.plugin.getDescription().getVersion();
                    if (!currentVersion.equals(this.latestVersion)) {
                        this.sendUpdateMessage(false);
                    }
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().info("Could not check for updates: " + e.getMessage());
            }
        });
    }

    private void sendUpdateMessage(boolean isLatest) {
        if (!isLatest) {
            String consoleMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)("&8-------------------\u029f\u026a\u0262\u029c\u1d1b\u0299\u029f\u1d0f\u1d04\u1d0b\u0280\u1d07\u1d0d\u1d0f\u1d20\u1d07-------------------\n\n&b\u029f\u026a\u0262\u029c\u1d1b\u0299\u029f\u1d0f\u1d04\u1d0b\u0280\u1d07\u1d0d\u1d0f\u1d20\u1d07\u279c &e\u26a0 A new update is available: &b" + this.latestVersion + "\n&b\u029f\u026a\u0262\u029c\u1d1b\u0299\u029f\u1d0f\u1d04\u1d0b\u0280\u1d07\u1d0d\u1d0f\u1d20\u1d07\u279c &7Your current version: &c" + this.plugin.getDescription().getVersion() + "\n&b\u029f\u026a\u0262\u029c\u1d1b\u0299\u029f\u1d0f\u1d04\u1d0b\u0280\u1d07\u1d0d\u1d0f\u1d20\u1d07\u279c &ePlease download the latest version: &f" + "https://www.spigotmc.org/resources/lightblockremove.122601/" + "\n&8-------------------\u029f\u026a\u0262\u029c\u1d1b\u0299\u029f\u1d0f\u1d04\u1d0b\u0280\u1d07\u1d0d\u1d0f\u1d20\u1d07-------------------\n"));
            Bukkit.getConsoleSender().sendMessage(consoleMessage);
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOp()) continue;
                TextComponent message = new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8&m-------------------\u029f\u026a\u0262\u029c\u1d1b\u0299\u029f\u1d0f\u1d04\u1d0b\u0280\u1d07\u1d0d\u1d0f\u1d20\u1d07-------------------\n\n&b\u029f\u026a\u0262\u029c\u1d1b\u0299\u029f\u1d0f\u1d04\u1d0b\u0280\u1d07\u1d0d\u1d0f\u1d20\u1d07\u279c &e\u26a0 A new update is available: &b" + this.latestVersion + "\n&b\u029f\u026a\u0262\u029c\u1d1b\u0299\u029f\u1d0f\u1d04\u1d0b\u0280\u1d07\u1d0d\u1d0f\u1d20\u1d07\u279c &7Your current version: &c" + this.plugin.getDescription().getVersion() + "\n")));
                TextComponent clickablePart = new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)"&e[Click to Update]"));
                clickablePart.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.spigotmc.org/resources/lightblockremove.122601/"));
                message.addExtra((BaseComponent)clickablePart);
                message.addExtra((BaseComponent)new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)"\n&8&m-------------------\u029f\u026a\u0262\u029c\u1d1b\u0299\u029f\u1d0f\u1d04\u1d0b\u0280\u1d07\u1d0d\u1d0f\u1d20\u1d07-------------------")));
                player.spigot().sendMessage((BaseComponent)message);
            }
        }
    }

    public void checkOnStartup() {
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, this::checkForUpdate, 20L);
    }

    public void startUpdateCheckTask() {
        new BukkitRunnable(){

            public void run() {
                UpdateChecker.this.checkForUpdate();
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 72000L, 72000L);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.isOp()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                if (this.latestVersion != null && !this.plugin.getDescription().getVersion().equals(this.latestVersion)) {
                    TextComponent message = new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8&m-------------------\u029f\u026a\u0262\u029c\u1d1b\u0299\u029f\u1d0f\u1d04\u1d0b\u0280\u1d07\u1d0d\u1d0f\u1d20\u1d07-------------------\n\n&b\u029f\u026a\u0262\u029c\u1d1b\u0299\u029f\u1d0f\u1d04\u1d0b\u0280\u1d07\u1d0d\u1d0f\u1d20\u1d07\u279c &e\u26a0 A new update is available: &b" + this.latestVersion + "\n&b\u029f\u026a\u0262\u029c\u1d1b\u0299\u029f\u1d0f\u1d04\u1d0b\u0280\u1d07\u1d0d\u1d0f\u1d20\u1d07\u279c &7Your current version: &c" + this.plugin.getDescription().getVersion() + "\n")));
                    TextComponent clickablePart = new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)"&e[Click to Update]"));
                    clickablePart.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.spigotmc.org/resources/lightblockremove.122601/"));
                    message.addExtra((BaseComponent)clickablePart);
                    message.addExtra((BaseComponent)new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)"\n&8&m-------------------\u029f\u026a\u0262\u029c\u1d1b\u0299\u029f\u1d0f\u1d04\u1d0b\u0280\u1d07\u1d0d\u1d0f\u1d20\u1d07-------------------")));
                    player.spigot().sendMessage((BaseComponent)message);
                }
            });
        }
    }
}

