/*
 * Decompiled with CFR 0.152.
 */
package com.mars.huskssand;

import com.mars.huskssand.HusksSandConfig;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class HuskLootModifier
extends LootModifier {
    private static final Item sandDrop = Blocks.SAND.asItem();
    public static final MapCodec<HuskLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, HuskLootModifier::new));

    public HuskLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext lootContext) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)lootContext)) continue;
            return generatedLoot;
        }
        RandomSource random = lootContext.getRandom();
        int rolls = random.nextIntBetweenInclusive(HusksSandConfig.min_rolls, HusksSandConfig.max_rolls);
        Player player = (Player)lootContext.getOptionalParameter(LootContextParams.LAST_DAMAGE_PLAYER);
        if (player != null) {
            ItemStack weapon = player.getMainHandItem();
            int lootingLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)lootContext.getLevel().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.LOOTING), (ItemStack)weapon);
            if (lootingLevel > 0) {
                rolls += random.nextIntBetweenInclusive(0, lootingLevel);
            }
        }
        generatedLoot.add((Object)new ItemStack((ItemLike)sandDrop, rolls));
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

