package com.sydders.mcciutils;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_310;
import net.minecraft.class_5250;


public class MCCIUtilsClient implements ClientModInitializer {
    @Override
    public void onInitializeClient() {
        AutoConfig.register(MCCIUtilsModConfig.class, JanksonConfigSerializer::new);
        MCCIUtilsModConfig config = AutoConfig.getConfigHolder(MCCIUtilsModConfig.class).getConfig();

        HudRenderCallback.EVENT.register(((drawContext, renderTickCounter) -> {
            class_5250 msg = MCCIUtils.ChatMessageStorage.latestMessage;
            long elapsed = System.currentTimeMillis() - MCCIUtils.ChatMessageStorage.lastUpdatedTime;

            if (msg != null && elapsed < config.fishHudFadeTime) {
                float opacity = 1.0f - ((float) elapsed / config.fishHudFadeTime);
                int alpha = (int)(opacity * 255) << 24;

                var textRenderer = class_310.method_1551().field_1772;
                int textWidth = textRenderer.method_27525(msg);
                int textHeight = textRenderer.field_2000;
                int x = 3;
                int y = 3;

                drawContext.method_25294(x - 2, y - 2, x + textWidth + 2, y + textHeight + 2, 0x80000000);
                drawContext.method_51439(textRenderer, msg, x, y, 0xFFFFFF | alpha, false);
            }
        }));
    }
}
