package com.sydders.mcciutils.mixin;

import com.sydders.mcciutils.MCCIUtils;
import com.sydders.mcciutils.MCCIUtilsModConfig;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_11719;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_7439;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static javax.swing.text.StyleConstants.FontFamily;

@Mixin(class_634.class)
public class ClientPlayNetworkHandlerMixin {
    MCCIUtilsModConfig config = AutoConfig.getConfigHolder(MCCIUtilsModConfig.class).getConfig();

    @Inject(method = "onGameMessage", at = @At("HEAD"), cancellable = true)
    public void onGameMessage(class_7439 packet, CallbackInfo ci) {
        if (!config.fishHud) {return;}
        String msg = packet.comp_763().getString();
        if (msg.toLowerCase().contains("you caught")) {
            Pattern pattern = Pattern.compile("\\[(.*?)\\]");
            Matcher matcher = pattern.matcher(msg);

            if (matcher.find()) {
                String fishNameRaw = matcher.group(1);

                StringBuilder normalText = new StringBuilder();
                StringBuilder iconText = new StringBuilder();

                for (char ch : fishNameRaw.toCharArray()) {
                    if (Character.UnicodeBlock.of(ch) == Character.UnicodeBlock.PRIVATE_USE_AREA) {
                        iconText.append(ch);
                    } else {
                        normalText.append(ch);
                    }
                }

                class_2561 iconComponent = class_2561.method_43470(iconText.toString())
                        .method_10862(class_2583.field_24360.method_27704(new class_11719.class_11721(class_2960.method_60655("mcc", "icon"))));
                class_2561 nameComponent = class_2561.method_43470(normalText.toString().trim());

                MCCIUtils.ChatMessageStorage.setMessage(class_2561.method_43473().method_10852(iconComponent).method_10852(nameComponent));

                MCCIUtils.LOGGER.info("Caught fish (text): " + normalText);
                MCCIUtils.LOGGER.info("Caught fish (icons): " + iconText);
            }
            ci.cancel();
        } else if (msg.toLowerCase().contains("triggered:")) {
            StringBuilder iconText = new StringBuilder();
            for (char ch : msg.toCharArray()) {
                if (Character.UnicodeBlock.of(ch) == Character.UnicodeBlock.PRIVATE_USE_AREA && ch != '\uE018') {
                    iconText.append(ch);
                }
            }

            if (!iconText.isEmpty()) {
                class_2561 iconComponent = class_2561.method_43470(iconText.toString())
                        .method_10862(class_2583.field_24360.method_27704(new class_11719.class_11721(class_2960.method_60655("mcc", "icon"))));

                if (MCCIUtils.ChatMessageStorage.latestMessage == null) {
                    MCCIUtils.ChatMessageStorage.setMessage(class_2561.method_43473());
                }

                MCCIUtils.ChatMessageStorage.setMessage(class_2561.method_43473().method_10852(MCCIUtils.ChatMessageStorage.latestMessage).method_27693(" ").method_10852(iconComponent));

                MCCIUtils.LOGGER.info("Triggered icons: " + iconText);
            }

            ci.cancel();
        } else if (msg.toLowerCase().contains("you earned:")) {
            Pattern pattern = Pattern.compile("You earned: (\\d+)");
            Matcher matcher = pattern.matcher(msg);
            int islandXp = 0;

            if (matcher.find()) {
                islandXp = Integer.parseInt(matcher.group(1));
                System.out.println("Island XP earned: " + islandXp);
            }

            if (islandXp != 0) {
                MCCIUtils.ChatMessageStorage.setMessage(class_2561.method_43473().method_10852(MCCIUtils.ChatMessageStorage.latestMessage).method_27693(" ").method_27693("+" + islandXp + "xp"));
            }

            ci.cancel();
        }

        if (msg.contains("Game Over!")) {
            class_310.method_1551().field_1724.field_3944.method_45729(config.gameOverMessage);
        }
    }
}
