/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core.data;

import org.mtr.core.data.Position;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.tool.Angle;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import top.mcmtr.core.data.MSDData;
import top.mcmtr.core.data.RigidCatenaryMath;
import top.mcmtr.core.generated.data.RigidCatenarySchema;

public final class RigidCatenary
extends RigidCatenarySchema {
    public final RigidCatenaryMath rigidCatenaryMath;
    private final boolean reversePositions;

    public static RigidCatenary copy(RigidCatenary rigidCatenary, Shape newShape, double newVerticalRadius) {
        return new RigidCatenary(rigidCatenary.position1, rigidCatenary.angle1, rigidCatenary.position2, rigidCatenary.angle2, newShape, newVerticalRadius);
    }

    public RigidCatenary(Position position1, Angle angle1, Position position2, Angle angle2, Shape shape, double verticalRadius) {
        super(position1, angle1, position2, angle2, shape, verticalRadius);
        this.reversePositions = position1.compareTo(position2) > 0;
        this.rigidCatenaryMath = this.reversePositions ? new RigidCatenaryMath(position2, angle2, position1, angle1, shape, verticalRadius) : new RigidCatenaryMath(position1, angle1, position2, angle2, shape, verticalRadius);
    }

    public RigidCatenary(ReaderBase readerBase) {
        super(readerBase);
        this.reversePositions = this.position1.compareTo(this.position2) > 0;
        this.rigidCatenaryMath = this.reversePositions ? new RigidCatenaryMath(this.position2, this.angle2, this.position1, this.angle1, this.shape, this.verticalRadius) : new RigidCatenaryMath(this.position1, this.angle1, this.position2, this.angle2, this.shape, this.verticalRadius);
    }

    protected Position getPosition1() {
        return this.position1;
    }

    protected Position getPosition2() {
        return this.position2;
    }

    public boolean isValid() {
        return this.rigidCatenaryMath.isValid();
    }

    public boolean closeTo(Position position, double radius) {
        return Utilities.isBetween((Position)position, (Position)this.position1, (Position)this.position2, (double)radius);
    }

    void writePositionsToRigidCatenaryCache(Object2ObjectOpenHashMap<Position, Object2ObjectOpenHashMap<Position, RigidCatenary>> positionsToCatenary) {
        MSDData.put(positionsToCatenary, this.position1, this.position2, oldValue -> this, Object2ObjectOpenHashMap::new);
        MSDData.put(positionsToCatenary, this.position2, this.position1, oldValue -> this, Object2ObjectOpenHashMap::new);
    }

    public static boolean verifyPosition(Position positionStart, Position positionEnd) {
        double zEnd;
        double yEnd;
        double xStart = positionStart.getX();
        double yStart = positionStart.getY();
        double zStart = positionStart.getZ();
        double xEnd = positionEnd.getX();
        return Math.sqrt((xEnd - xStart) * (xEnd - xStart) + ((yEnd = (double)positionEnd.getY()) - yStart) * (yEnd - yStart) + ((zEnd = (double)positionEnd.getZ()) - zStart) * (zEnd - zStart)) > 0.0;
    }

    public static enum Shape {
        QUADRATIC,
        TWO_RADII;

    }
}

