/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core.data;

import org.mtr.core.data.Position;
import org.mtr.core.tool.Angle;
import org.mtr.core.tool.Vector;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import top.mcmtr.core.data.RigidCatenary;
import top.mcmtr.core.data.SolidVectorLocation;
import top.mcmtr.mod.config.Config;

public final class RigidCatenaryMath {
    private final RigidCatenary.Shape shape;
    private final double verticalRadius;
    private final double h1;
    private final double k1;
    private final double h2;
    private final double k2;
    private final double r1;
    private final double r2;
    private final double tStart1;
    private final double tEnd1;
    private final double tStart2;
    private final double tEnd2;
    private final long yStart;
    private final long yEnd;
    private final boolean reverseT1;
    private final boolean reverseT2;
    private final boolean isStraight1;
    private final boolean isStraight2;
    private boolean checkRun = false;
    private final ObjectArrayList<SolidVectorLocation> corners1 = new ObjectArrayList();
    private final ObjectArrayList<SolidVectorLocation> corners2 = new ObjectArrayList();
    private static final double ACCEPT_THRESHOLD = 1.0E-4;

    public RigidCatenaryMath(Position position1, Angle angle1, Position position2, Angle angle2, RigidCatenary.Shape shape, double verticalRadius) {
        long xStart = position1.getX();
        long zStart = position1.getZ();
        long xEnd = position2.getX();
        long zEnd = position2.getZ();
        Vector vecDifference = new Vector((double)(position2.getX() - position1.getX()), 0.0, (double)(position2.getZ() - position1.getZ()));
        Vector vecDifferenceRotated = vecDifference.rotateY((double)((float)angle1.angleRadians));
        double deltaForward = vecDifferenceRotated.z;
        double deltaSide = vecDifferenceRotated.x;
        if (angle1.isParallel(angle2)) {
            if (Math.abs(deltaForward) < 1.0E-4) {
                this.h1 = angle1.cos;
                this.k1 = angle1.sin;
                if (Math.abs(this.h1) >= 0.5 && Math.abs(this.k1) >= 0.5) {
                    this.r1 = (this.h1 * (double)zStart - this.k1 * (double)xStart) / this.h1 / this.h1;
                    this.tStart1 = (double)xStart / this.h1;
                    this.tEnd1 = (double)xEnd / this.h1;
                } else {
                    double div = angle1.add((Angle)angle1).cos;
                    this.r1 = (this.h1 * (double)zStart - this.k1 * (double)xStart) / div;
                    this.tStart1 = (this.h1 * (double)xStart - this.k1 * (double)zStart) / div;
                    this.tEnd1 = (this.h1 * (double)xEnd - this.k1 * (double)zEnd) / div;
                }
                this.r2 = 0.0;
                this.k2 = 0.0;
                this.h2 = 0.0;
                this.reverseT1 = this.tStart1 > this.tEnd1;
                this.reverseT2 = false;
                this.isStraight2 = true;
                this.isStraight1 = true;
                this.tEnd2 = 0.0;
                this.tStart2 = 0.0;
            } else if (Math.abs(deltaSide) > 1.0E-4) {
                double radius = (deltaForward * deltaForward + deltaSide * deltaSide) / (4.0 * deltaForward);
                this.r1 = this.r2 = Math.abs(radius);
                this.h1 = (double)xStart - radius * angle1.sin;
                this.k1 = (double)zStart + radius * angle1.cos;
                this.h2 = (double)xEnd - radius * angle2.sin;
                this.k2 = (double)zEnd + radius * angle2.cos;
                this.reverseT1 = deltaForward < 0.0 != deltaSide < 0.0;
                this.reverseT2 = !this.reverseT1;
                this.tStart1 = RigidCatenaryMath.getTBounds(xStart, this.h1, zStart, this.k1, this.r1);
                this.tEnd1 = RigidCatenaryMath.getTBounds((double)xStart + vecDifference.x / 2.0, this.h1, (double)zStart + vecDifference.z / 2.0, this.k1, this.r1, this.tStart1, this.reverseT1);
                this.tStart2 = RigidCatenaryMath.getTBounds((double)xStart + vecDifference.x / 2.0, this.h2, (double)zStart + vecDifference.z / 2.0, this.k2, this.r2);
                this.tEnd2 = RigidCatenaryMath.getTBounds(xEnd, this.h2, zEnd, this.k2, this.r2, this.tStart2, this.reverseT2);
                this.isStraight2 = false;
                this.isStraight1 = false;
            } else {
                this.r2 = 0.0;
                this.r1 = 0.0;
                this.k2 = 0.0;
                this.h2 = 0.0;
                this.k1 = 0.0;
                this.h1 = 0.0;
                this.tEnd2 = 0.0;
                this.tEnd1 = 0.0;
                this.tStart2 = 0.0;
                this.tStart1 = 0.0;
                this.reverseT1 = false;
                this.reverseT2 = false;
                this.isStraight2 = true;
                this.isStraight1 = true;
            }
        } else {
            Angle newAngle1 = vecDifferenceRotated.x < -1.0E-4 ? angle1.getOpposite() : angle1;
            Angle newAngle2 = angle2.cos * vecDifference.x + angle2.sin * vecDifference.z < -1.0E-4 ? angle2.getOpposite() : angle2;
            double angleForward = Math.atan2(deltaForward, deltaSide);
            Angle railAngleDifference = newAngle2.sub(newAngle1);
            double angleDifference = railAngleDifference.angleRadians;
            if (Math.signum(angleForward) == Math.signum(angleDifference)) {
                double absAngleForward = Math.abs(angleForward);
                if (absAngleForward - Math.abs(angleDifference / 2.0) < 1.0E-4) {
                    double offsetSide = Math.abs(deltaForward / railAngleDifference.halfTan);
                    double remainingSide = deltaSide - offsetSide;
                    double deltaXEnd = (double)xStart + remainingSide * newAngle1.cos;
                    double deltaZEnd = (double)zStart + remainingSide * newAngle1.sin;
                    this.h1 = newAngle1.cos;
                    this.k1 = newAngle1.sin;
                    if (Math.abs(this.h1) >= 0.5 && Math.abs(this.k1) >= 0.5) {
                        this.r1 = (this.h1 * (double)zStart - this.k1 * (double)xStart) / this.h1 / this.h1;
                        this.tStart1 = (double)xStart / this.h1;
                        this.tEnd1 = deltaXEnd / this.h1;
                    } else {
                        double div = newAngle1.add((Angle)newAngle1).cos;
                        this.r1 = (this.h1 * (double)zStart - this.k1 * (double)xStart) / div;
                        this.tStart1 = (this.h1 * (double)xStart - this.k1 * (double)zStart) / div;
                        this.tEnd1 = (this.h1 * deltaXEnd - this.k1 * deltaZEnd) / div;
                    }
                    this.isStraight1 = true;
                    this.reverseT1 = this.tStart1 > this.tEnd1;
                    double radius = deltaForward / (1.0 - railAngleDifference.cos);
                    this.r2 = Math.abs(radius);
                    this.h2 = deltaXEnd - radius * newAngle1.sin;
                    this.k2 = deltaZEnd + radius * newAngle1.cos;
                    this.reverseT2 = deltaForward < 0.0;
                    this.tStart2 = RigidCatenaryMath.getTBounds(deltaXEnd, this.h2, deltaZEnd, this.k2, this.r2);
                    this.tEnd2 = RigidCatenaryMath.getTBounds(xEnd, this.h2, zEnd, this.k2, this.r2, this.tStart2, this.reverseT2);
                    this.isStraight2 = false;
                } else if (absAngleForward - Math.abs(angleDifference) < 1.0E-4) {
                    double crossSide = deltaForward / railAngleDifference.tan;
                    double remainingSide = (deltaSide - crossSide) * (1.0 + railAngleDifference.cos);
                    double remainingForward = (deltaSide - crossSide) * railAngleDifference.sin;
                    double deltaXEnd = (double)xStart + remainingSide * newAngle1.cos - remainingForward * newAngle1.sin;
                    double deltaZEnd = (double)zStart + remainingSide * newAngle1.sin + remainingForward * newAngle1.cos;
                    double radius = (deltaSide - deltaForward / railAngleDifference.tan) / railAngleDifference.halfTan;
                    this.r1 = Math.abs(radius);
                    this.h1 = (double)xStart - radius * newAngle1.sin;
                    this.k1 = (double)zStart + radius * newAngle1.cos;
                    this.isStraight1 = false;
                    this.reverseT1 = deltaForward < 0.0;
                    this.tStart1 = RigidCatenaryMath.getTBounds(xStart, this.h1, zStart, this.k1, this.r1);
                    this.tEnd1 = RigidCatenaryMath.getTBounds(deltaXEnd, this.h1, deltaZEnd, this.k1, this.r1, this.tStart1, this.reverseT1);
                    this.h2 = newAngle2.cos;
                    this.k2 = newAngle2.sin;
                    if (Math.abs(this.h2) >= 0.5 && Math.abs(this.k2) >= 0.5) {
                        this.r2 = (this.h2 * deltaZEnd - this.k2 * deltaXEnd) / this.h2 / this.h2;
                        this.tStart2 = deltaXEnd / this.h2;
                        this.tEnd2 = (double)xEnd / this.h2;
                    } else {
                        double div = newAngle2.add((Angle)newAngle2).cos;
                        this.r2 = (this.h2 * deltaZEnd - this.k2 * deltaXEnd) / div;
                        this.tStart2 = (this.h2 * deltaXEnd - this.k2 * deltaZEnd) / div;
                        this.tEnd2 = (this.h2 * (double)xEnd - this.k2 * (double)zEnd) / div;
                    }
                    this.isStraight2 = true;
                    this.reverseT2 = this.tStart2 > this.tEnd2;
                } else {
                    this.r2 = 0.0;
                    this.r1 = 0.0;
                    this.k2 = 0.0;
                    this.h2 = 0.0;
                    this.k1 = 0.0;
                    this.h1 = 0.0;
                    this.tEnd2 = 0.0;
                    this.tEnd1 = 0.0;
                    this.tStart2 = 0.0;
                    this.tStart1 = 0.0;
                    this.reverseT1 = false;
                    this.reverseT2 = false;
                    this.isStraight2 = true;
                    this.isStraight1 = true;
                }
            } else {
                this.r2 = 0.0;
                this.r1 = 0.0;
                this.k2 = 0.0;
                this.h2 = 0.0;
                this.k1 = 0.0;
                this.h1 = 0.0;
                this.tEnd2 = 0.0;
                this.tEnd1 = 0.0;
                this.tStart2 = 0.0;
                this.tStart1 = 0.0;
                this.reverseT1 = false;
                this.reverseT2 = false;
                this.isStraight2 = true;
                this.isStraight1 = true;
            }
        }
        this.yStart = position1.getY();
        this.yEnd = position2.getY();
        this.shape = shape;
        this.verticalRadius = Math.min(verticalRadius, this.getMaxVerticalRadius());
    }

    public void init() {
        if (!this.checkRun) {
            double y2;
            double y1;
            Vector corner8;
            Vector corner7;
            Vector corner6;
            Vector corner5;
            Vector corner4;
            Vector corner3;
            Vector corner2;
            Vector corner1;
            double t2;
            double t1;
            double i;
            int SEGMENT_LENGTH = Config.getRigidCatenarySegmentLength();
            double count1 = Math.abs(this.tEnd1 - this.tStart1);
            double count2 = Math.abs(this.tEnd2 - this.tStart2);
            double segment_count1 = Math.round(count1 / (double)SEGMENT_LENGTH);
            double segment_count2 = Math.round(count2 / (double)SEGMENT_LENGTH);
            double increment1 = count1 / Math.max(1.0, segment_count1);
            double increment2 = count2 / Math.max(1.0, segment_count2);
            double rawValueOffset = Math.abs(this.tEnd1 - this.tStart1);
            for (i = 0.0; i < count1 - 0.1; i += increment1) {
                t1 = (double)(this.reverseT1 ? -1 : 1) * i + this.tStart1;
                t2 = (double)(this.reverseT1 ? -1 : 1) * (i + increment1) + this.tStart1;
                corner1 = RigidCatenaryMath.getPositionXZ(this.h1, this.k1, this.r1, t1, -0.015625, this.isStraight1);
                corner2 = RigidCatenaryMath.getPositionXZ(this.h1, this.k1, this.r1, t1, 0.015625, this.isStraight1);
                corner3 = RigidCatenaryMath.getPositionXZ(this.h1, this.k1, this.r1, t2, 0.015625, this.isStraight1);
                corner4 = RigidCatenaryMath.getPositionXZ(this.h1, this.k1, this.r1, t2, -0.015625, this.isStraight1);
                corner5 = RigidCatenaryMath.getPositionXZ(this.h1, this.k1, this.r1, t1, -0.09375, this.isStraight1);
                corner6 = RigidCatenaryMath.getPositionXZ(this.h1, this.k1, this.r1, t1, 0.09375, this.isStraight1);
                corner7 = RigidCatenaryMath.getPositionXZ(this.h1, this.k1, this.r1, t2, 0.09375, this.isStraight1);
                corner8 = RigidCatenaryMath.getPositionXZ(this.h1, this.k1, this.r1, t2, -0.09375, this.isStraight1);
                y1 = this.getPositionY(i);
                y2 = this.getPositionY(i + increment1);
                SolidVectorLocation locationTemp1 = new SolidVectorLocation(corner1.x, corner1.z, corner2.x, corner2.z, corner3.x, corner3.z, corner4.x, corner4.z, corner5.x, corner5.z, corner6.x, corner6.z, corner7.x, corner7.z, corner8.x, corner8.z, y1, y2);
                this.corners1.add((Object)locationTemp1);
            }
            for (i = 0.0; i < count2 - 0.1; i += increment2) {
                t1 = (double)(this.reverseT2 ? -1 : 1) * i + this.tStart2;
                t2 = (double)(this.reverseT2 ? -1 : 1) * (i + increment2) + this.tStart2;
                corner1 = RigidCatenaryMath.getPositionXZ(this.h2, this.k2, this.r2, t1, -0.015625, this.isStraight2);
                corner2 = RigidCatenaryMath.getPositionXZ(this.h2, this.k2, this.r2, t1, 0.015625, this.isStraight2);
                corner3 = RigidCatenaryMath.getPositionXZ(this.h2, this.k2, this.r2, t2, 0.015625, this.isStraight2);
                corner4 = RigidCatenaryMath.getPositionXZ(this.h2, this.k2, this.r2, t2, -0.015625, this.isStraight2);
                corner5 = RigidCatenaryMath.getPositionXZ(this.h2, this.k2, this.r2, t1, -0.09375, this.isStraight2);
                corner6 = RigidCatenaryMath.getPositionXZ(this.h2, this.k2, this.r2, t1, 0.09375, this.isStraight2);
                corner7 = RigidCatenaryMath.getPositionXZ(this.h2, this.k2, this.r2, t2, 0.09375, this.isStraight2);
                corner8 = RigidCatenaryMath.getPositionXZ(this.h2, this.k2, this.r2, t2, -0.09375, this.isStraight2);
                y1 = this.getPositionY(i + rawValueOffset);
                y2 = this.getPositionY(i + increment2 + rawValueOffset);
                SolidVectorLocation locationTemp = new SolidVectorLocation(corner1.x, corner1.z, corner2.x, corner2.z, corner3.x, corner3.z, corner4.x, corner4.z, corner5.x, corner5.z, corner6.x, corner6.z, corner7.x, corner7.z, corner8.x, corner8.z, y1, y2);
                this.corners2.add((Object)locationTemp);
            }
            this.checkRun = !this.checkRun;
        }
    }

    public void render(RenderRigidCatenary callback) {
        this.init();
        this.renderSegment(this.corners1, callback);
        this.renderSegment(this.corners2, callback);
    }

    private void renderSegment(ObjectArrayList<SolidVectorLocation> vecLocations, RenderRigidCatenary callback) {
        for (SolidVectorLocation vecLocation : vecLocations) {
            callback.renderRigidCatenary(vecLocation.x1, vecLocation.z1, vecLocation.x2, vecLocation.z2, vecLocation.x3, vecLocation.z3, vecLocation.x4, vecLocation.z4, vecLocation.xs1, vecLocation.zs1, vecLocation.xs2, vecLocation.zs2, vecLocation.xs3, vecLocation.zs3, vecLocation.xs4, vecLocation.zs4, vecLocation.y1, vecLocation.y2);
        }
    }

    public double getLength() {
        return Math.abs(this.tEnd2 - this.tStart2) + Math.abs(this.tEnd1 - this.tStart1);
    }

    public RigidCatenary.Shape getShape() {
        return this.shape;
    }

    public double getVerticalRadius() {
        return this.verticalRadius;
    }

    public double getMaxVerticalRadius() {
        double length = this.getLength();
        double height = this.yEnd - this.yStart;
        return Math.floor((length * length + height * height) * 100.0 / Math.abs(4.0 * height)) / 100.0;
    }

    boolean isValid() {
        return this.h1 != 0.0 || this.k1 != 0.0 || this.h2 != 0.0 || this.k2 != 0.0 || this.r1 != 0.0 || this.r2 != 0.0 || this.tStart1 != 0.0 || this.tStart2 != 0.0 || this.tEnd1 != 0.0 || this.tEnd2 != 0.0;
    }

    private double getPositionY(double value) {
        double offsetValue;
        double yInitial;
        double yChange;
        if (this.yStart == this.yEnd) {
            return this.yStart;
        }
        double length = this.getLength();
        if (this.shape == RigidCatenary.Shape.TWO_RADII) {
            int sign;
            if (this.verticalRadius <= 0.0) {
                return value / length * (double)(this.yEnd - this.yStart) + (double)this.yStart;
            }
            double vTheta = this.getVTheta();
            double curveLength = Math.sin(vTheta) * this.verticalRadius;
            double curveHeight = (1.0 - Math.cos(vTheta)) * this.verticalRadius;
            int n = sign = this.yStart < this.yEnd ? 1 : -1;
            if (value < curveLength) {
                return (double)sign * (this.verticalRadius - Math.sqrt(this.verticalRadius * this.verticalRadius - value * value)) + (double)this.yStart;
            }
            if (value > length - curveLength) {
                double r = length - value;
                return (double)(-sign) * (this.verticalRadius - Math.sqrt(this.verticalRadius * this.verticalRadius - r * r)) + (double)this.yEnd;
            }
            return (double)sign * ((value - curveLength) / (length - 2.0 * curveLength) * ((double)Math.abs(this.yEnd - this.yStart) - 2.0 * curveHeight) + curveHeight) + (double)this.yStart;
        }
        double intercept = length / 2.0;
        if (value < intercept) {
            yChange = (double)(this.yEnd - this.yStart) / 2.0;
            yInitial = this.yStart;
            offsetValue = value;
        } else {
            yChange = (double)(this.yStart - this.yEnd) / 2.0;
            yInitial = this.yEnd;
            offsetValue = length - value;
        }
        return yChange * offsetValue * offsetValue / (intercept * intercept) + yInitial;
    }

    private double getVTheta() {
        double height = Math.abs(this.yEnd - this.yStart);
        double length = this.getLength();
        return 2.0 * Math.atan2(Math.sqrt(height * height - 4.0 * this.verticalRadius * height + length * length) - length, height - 4.0 * this.verticalRadius);
    }

    private static Vector getPositionXZ(double h, double k, double r, double t, double radiusOffset, boolean isStraight) {
        if (isStraight) {
            return new Vector(h * t + k * ((Math.abs(h) >= 0.5 && Math.abs(k) >= 0.5 ? 0.0 : r) + radiusOffset) + 0.5, 0.0, k * t + h * (r - radiusOffset) + 0.5);
        }
        return new Vector(h + (r + radiusOffset) * Math.cos(t / r) + 0.5, 0.0, k + (r + radiusOffset) * Math.sin(t / r) + 0.5);
    }

    private static double getTBounds(double x, double h, double z, double k, double r) {
        return Math.atan2(z - k, x - h) * r;
    }

    private static double getTBounds(double x, double h, double z, double k, double r, double tStart, boolean reverse) {
        double t = RigidCatenaryMath.getTBounds(x, h, z, k, r);
        if (t < tStart && !reverse) {
            return t + Math.PI * 2 * r;
        }
        if (t > tStart && reverse) {
            return t - Math.PI * 2 * r;
        }
        return t;
    }

    @FunctionalInterface
    public static interface RenderRigidCatenary {
        public void renderRigidCatenary(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23, double var25, double var27, double var29, double var31, double var33, double var35);
    }
}

