/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core.data;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mtr.core.data.Position;
import org.mtr.core.serializer.SerializedDataBaseWithId;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectSet;
import top.mcmtr.core.MSDMain;
import top.mcmtr.core.data.Catenary;
import top.mcmtr.core.data.RigidCatenary;

public abstract class MSDData {
    public final ObjectArraySet<Catenary> catenaries = new ObjectArraySet();
    public final Object2ObjectOpenHashMap<String, Catenary> catenaryIdMap = new Object2ObjectOpenHashMap();
    public final Object2ObjectOpenHashMap<Position, Object2ObjectOpenHashMap<Position, Catenary>> positionsToCatenary = new Object2ObjectOpenHashMap();
    public final ObjectArraySet<RigidCatenary> rigidCatenaries = new ObjectArraySet();
    public final Object2ObjectOpenHashMap<String, RigidCatenary> rigidCatenaryIdMap = new Object2ObjectOpenHashMap();
    public final Object2ObjectOpenHashMap<Position, Object2ObjectOpenHashMap<Position, RigidCatenary>> positionsToRigidCatenary = new Object2ObjectOpenHashMap();

    public void sync() {
        try {
            this.positionsToCatenary.clear();
            this.catenaries.forEach(catenary -> catenary.writePositionsToCatenaryCache(this.positionsToCatenary));
            MSDData.mapIds(this.catenaryIdMap, this.catenaries);
            this.positionsToRigidCatenary.clear();
            this.rigidCatenaries.forEach(rigidCatenary -> rigidCatenary.writePositionsToRigidCatenaryCache(this.positionsToRigidCatenary));
            MSDData.mapIds(this.rigidCatenaryIdMap, this.rigidCatenaries);
        }
        catch (Exception e) {
            MSDMain.MSD_CORE_LOG.error("MSD Data sync error", (Throwable)e);
        }
    }

    public static <T, U, V, W extends Map<T, X>, X extends Map<U, V>> void put(W map, T key1, U key2, Function<V, V> putValue, Supplier<X> innerMapSupplier) {
        Map newInnerMap;
        Map innerMap = (Map)map.get(key1);
        if (innerMap == null) {
            newInnerMap = (Map)innerMapSupplier.get();
            map.put(key1, (Map)newInnerMap);
        } else {
            newInnerMap = innerMap;
        }
        newInnerMap.put(key2, putValue.apply(newInnerMap.get(key2)));
    }

    private static <U extends SerializedDataBaseWithId> void mapIds(Object2ObjectMap<String, U> map, ObjectSet<U> source) {
        map.clear();
        source.forEach(data -> {
            SerializedDataBaseWithId cfr_ignored_0 = (SerializedDataBaseWithId)map.put((Object)data.getHexId(), data);
        });
    }
}

