/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core.legacy.data;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import java.util.UUID;
import org.mtr.core.data.Position;
import org.mtr.core.simulation.FileLoader;
import org.mtr.core.tool.Angle;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectSet;
import top.mcmtr.core.MSDMain;
import top.mcmtr.core.data.Catenary;
import top.mcmtr.core.data.CatenaryType;
import top.mcmtr.core.data.OffsetPosition;
import top.mcmtr.core.data.RigidCatenary;
import top.mcmtr.core.legacy.data.CatenaryNodeConnection;
import top.mcmtr.core.legacy.data.LegacyCatenaryNode;
import top.mcmtr.core.legacy.data.LegacyRigidCatenaryNode;
import top.mcmtr.core.legacy.data.LegacyTransCatenaryNode;
import top.mcmtr.core.legacy.data.RigidCatenaryNodeConnection;
import top.mcmtr.core.legacy.data.TransCatenaryNodeConnection;

public final class LegacyCatenaryLoader {
    private static final String KEY_CATENARIES = "catenaries";
    private static final String KEY_RIGID_CATENARIES = "rigid_catenaries";
    private static final String KEY_TRANS_CATENARIES = "trans_catenaries";

    public static void loadTransCatenary(Path savePath, ObjectArraySet<Catenary> catenaries) {
        ObjectArraySet legacyTransCatenaryNodes = new ObjectArraySet();
        new FileLoader((ObjectSet)legacyTransCatenaryNodes, LegacyTransCatenaryNode::new, savePath, KEY_TRANS_CATENARIES);
        Object2ObjectOpenHashMap transCatenaryCache = new Object2ObjectOpenHashMap();
        legacyTransCatenaryNodes.forEach(legacyTransCatenaryNode -> {
            Position startPosition = legacyTransCatenaryNode.getStartPosition();
            long startPositionLong = legacyTransCatenaryNode.getStartPositionLong();
            legacyTransCatenaryNode.iterateConnections(transCatenaryNodeConnection -> {
                TransCatenaryNodeConnection.CatenaryType catenaryType = transCatenaryNodeConnection.getCatenaryType();
                Position endPosition = transCatenaryNodeConnection.getEndPoint();
                long endPositionLong = transCatenaryNodeConnection.getEndPointLong();
                UUID uuid = LegacyCatenaryLoader.getUuid(startPositionLong, endPositionLong);
                TransCatenaryNodeConnection.CatenaryType oldCatenaryType = (TransCatenaryNodeConnection.CatenaryType)((Object)((Object)((Object)transCatenaryCache.get((Object)uuid))));
                if (oldCatenaryType != null) {
                    OffsetPosition startOffsetPosition = new OffsetPosition(transCatenaryNodeConnection.getTransXStart() - (double)startPosition.getX(), transCatenaryNodeConnection.getTransYStart() - (double)startPosition.getY(), transCatenaryNodeConnection.getTransZStart() - (double)startPosition.getZ());
                    OffsetPosition endOffsetPosition = new OffsetPosition(transCatenaryNodeConnection.getTransXEnd() - (double)endPosition.getX(), transCatenaryNodeConnection.getTransYEnd() - (double)endPosition.getY(), transCatenaryNodeConnection.getTransZEnd() - (double)endPosition.getZ());
                    Catenary catenary = Objects.requireNonNull(catenaryType) == TransCatenaryNodeConnection.CatenaryType.TRANS_CATENARY ? new Catenary(startPosition, endPosition, startOffsetPosition, endOffsetPosition, CatenaryType.CATENARY) : new Catenary(startPosition, endPosition, startOffsetPosition, endOffsetPosition, CatenaryType.ELECTRIC);
                    catenaries.add((Object)catenary);
                } else {
                    transCatenaryCache.put((Object)uuid, (Object)catenaryType);
                }
            });
        });
        Path transCatenarySavePath = savePath.resolve(KEY_TRANS_CATENARIES);
        if (Files.exists(transCatenarySavePath, new LinkOption[0])) {
            try {
                Files.walkFileTree(transCatenarySavePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
                Files.deleteIfExists(transCatenarySavePath);
            }
            catch (IOException e) {
                MSDMain.MSD_CORE_LOG.error("TransCatenary files delete fail,ignored");
            }
        }
    }

    public static void loadCatenary(Path savePath, ObjectArraySet<Catenary> catenaries) {
        ObjectArraySet legacyCatenaryNodes = new ObjectArraySet();
        new FileLoader((ObjectSet)legacyCatenaryNodes, LegacyCatenaryNode::new, savePath, KEY_CATENARIES);
        Object2ObjectOpenHashMap catenaryCache = new Object2ObjectOpenHashMap();
        legacyCatenaryNodes.forEach(legacyCatenaryNode -> {
            Position startPosition = legacyCatenaryNode.getStartPosition();
            long startPositionLong = legacyCatenaryNode.getStartPositionLong();
            legacyCatenaryNode.iterateConnections(catenaryNodeConnection -> {
                CatenaryNodeConnection.CatenaryType catenaryType = catenaryNodeConnection.getCatenaryType();
                Position endPosition = catenaryNodeConnection.getEndPoint();
                long endPositionLong = catenaryNodeConnection.getEndPointLong();
                UUID uuid = LegacyCatenaryLoader.getUuid(startPositionLong, endPositionLong);
                CatenaryNodeConnection.CatenaryType oldCatenaryType = (CatenaryNodeConnection.CatenaryType)((Object)((Object)((Object)catenaryCache.get((Object)uuid))));
                if (oldCatenaryType != null) {
                    Catenary catenary;
                    switch (catenaryType) {
                        case CATENARY: {
                            catenary = new Catenary(startPosition, endPosition, new OffsetPosition(0.0, 0.0, 0.0), new OffsetPosition(0.0, 0.0, 0.0), CatenaryType.CATENARY);
                            break;
                        }
                        case ELECTRIC: {
                            catenary = new Catenary(startPosition, endPosition, new OffsetPosition(0.0, 0.0, 0.0), new OffsetPosition(0.0, 0.0, 0.0), CatenaryType.ELECTRIC);
                            break;
                        }
                        default: {
                            catenary = new Catenary(startPosition, endPosition, new OffsetPosition(0.0, 0.0, 0.0), new OffsetPosition(0.0, 0.0, 0.0), CatenaryType.RIGID_SOFT_CATENARY);
                        }
                    }
                    catenaries.add((Object)catenary);
                } else {
                    catenaryCache.put((Object)uuid, (Object)catenaryType);
                }
            });
        });
    }

    public static void loadRigidCatenary(Path savePath, ObjectArraySet<RigidCatenary> rigidCatenaries) {
        ObjectArraySet legacyRigidCatenaryNodes = new ObjectArraySet();
        new FileLoader((ObjectSet)legacyRigidCatenaryNodes, LegacyRigidCatenaryNode::new, savePath, KEY_RIGID_CATENARIES);
        Object2ObjectOpenHashMap rigidCatenaryCache = new Object2ObjectOpenHashMap();
        legacyRigidCatenaryNodes.forEach(legacyRigidCatenaryNode -> {
            Position startPosition = legacyRigidCatenaryNode.getStartPosition();
            long startPositionLong = legacyRigidCatenaryNode.getStartPositionLong();
            legacyRigidCatenaryNode.iterateConnections(rigidCatenaryNodeConnection -> {
                Position endPosition = rigidCatenaryNodeConnection.getEndPosition();
                long endPositionLong = rigidCatenaryNodeConnection.getEndPositionLong();
                Angle startAngle = rigidCatenaryNodeConnection.getStartAngle();
                Angle endAngle = rigidCatenaryNodeConnection.getEndAngle();
                UUID uuid = LegacyCatenaryLoader.getUuid(startPositionLong, endPositionLong);
                RigidCatenaryNodeConnection oldRigidCatenaryConnection = (RigidCatenaryNodeConnection)rigidCatenaryCache.get((Object)uuid);
                if (oldRigidCatenaryConnection != null) {
                    RigidCatenary rigidCatenary = new RigidCatenary(startPosition, startAngle, endPosition, endAngle, RigidCatenary.Shape.QUADRATIC, 0.0);
                    rigidCatenaries.add((Object)rigidCatenary);
                } else {
                    rigidCatenaryCache.put((Object)uuid, rigidCatenaryNodeConnection);
                }
            });
        });
    }

    private static UUID getUuid(long value1, long value2) {
        return value1 > value2 ? new UUID(value1, value2) : new UUID(value2, value1);
    }
}

