/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core.operation;

import javax.annotation.Nullable;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectSet;
import top.mcmtr.core.data.Catenary;
import top.mcmtr.core.data.MSDData;
import top.mcmtr.core.data.RigidCatenary;
import top.mcmtr.core.generated.operation.MSDUpdateDataRequestSchema;
import top.mcmtr.core.operation.MSDUpdateDataResponse;

public final class MSDUpdateDataRequest
extends MSDUpdateDataRequestSchema {
    private final MSDData data;

    public MSDUpdateDataRequest(MSDData data) {
        this.data = data;
    }

    public MSDUpdateDataRequest(ReaderBase readerBase, MSDData data) {
        super(readerBase);
        this.data = data;
        this.updateData(readerBase);
    }

    public MSDUpdateDataRequest addCatenary(Catenary catenary) {
        this.catenaries.add((Object)catenary);
        return this;
    }

    public MSDUpdateDataRequest addRigidCatenary(RigidCatenary rigidCatenary) {
        this.rigidCatenaries.add((Object)rigidCatenary);
        return this;
    }

    public MSDUpdateDataResponse update() {
        MSDUpdateDataResponse updateDataResponse = new MSDUpdateDataResponse(this.data);
        this.catenaries.forEach(catenary -> MSDUpdateDataRequest.update(catenary, (SerializedDataBase)this.data.catenaryIdMap.get((Object)catenary.getHexId()), this.data.catenaries, updateDataResponse.getCatenaries()));
        this.rigidCatenaries.forEach(rigidCatenary -> MSDUpdateDataRequest.update(rigidCatenary, (SerializedDataBase)this.data.rigidCatenaryIdMap.get((Object)rigidCatenary.getHexId()), this.data.rigidCatenaries, updateDataResponse.getRigidCatenaries()));
        this.data.sync();
        return updateDataResponse;
    }

    private static <T extends SerializedDataBase> void update(T newData, @Nullable T existingData, ObjectSet<T> dataSet, ObjectArrayList<T> dataToUpdate) {
        if (existingData != null) {
            dataSet.remove(existingData);
        }
        dataSet.add(newData);
        dataToUpdate.add(newData);
    }
}

