/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core.operation;

import javax.annotation.Nullable;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectSet;
import top.mcmtr.core.data.Catenary;
import top.mcmtr.core.data.MSDData;
import top.mcmtr.core.data.RigidCatenary;
import top.mcmtr.core.generated.operation.MSDUpdateDataResponseSchema;

public final class MSDUpdateDataResponse
extends MSDUpdateDataResponseSchema {
    private final MSDData data;

    public MSDUpdateDataResponse(MSDData data) {
        this.data = data;
    }

    public MSDUpdateDataResponse(ReaderBase readerBase, MSDData data) {
        super(readerBase);
        this.data = data;
        this.updateData(readerBase);
    }

    public void write() {
        this.catenaries.forEach(catenary -> MSDUpdateDataResponse.update(catenary, this.data.catenaries, (SerializedDataBase)this.data.catenaryIdMap.get((Object)catenary.getHexId())));
        this.rigidCatenaries.forEach(rigidCatenary -> MSDUpdateDataResponse.update(rigidCatenary, this.data.rigidCatenaries, (SerializedDataBase)this.data.rigidCatenaryIdMap.get((Object)rigidCatenary.getHexId())));
        this.data.sync();
    }

    ObjectArrayList<Catenary> getCatenaries() {
        return this.catenaries;
    }

    ObjectArrayList<RigidCatenary> getRigidCatenaries() {
        return this.rigidCatenaries;
    }

    private static <T extends SerializedDataBase> void update(T newData, ObjectSet<T> dataSet, @Nullable T existingData) {
        if (existingData != null) {
            dataSet.remove(existingData);
        }
        dataSet.add(newData);
    }
}

