/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.blocks;

import java.util.List;
import org.mtr.core.tool.Angle;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Init;
import org.mtr.mod.Items;
import org.mtr.mod.block.IBlock;
import top.mcmtr.core.data.RigidCatenary;
import top.mcmtr.mod.BlockEntityTypes;
import top.mcmtr.mod.blocks.BlockNodeBase;
import top.mcmtr.mod.client.MSDMinecraftClientData;
import top.mcmtr.mod.packet.MSDClientPacketHelper;
import top.mcmtr.mod.packet.MSDPacketDeleteData;

public final class BlockRigidCatenaryNode
extends BlockNodeBase {
    public static final BooleanProperty FACING = BooleanProperty.of((String)"facing");
    public static final BooleanProperty IS_22_5 = BooleanProperty.of((String)"is_22_5");
    public static final BooleanProperty IS_45 = BooleanProperty.of((String)"is_45");

    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        if (world.isClient() && player.isHolding(Items.BRUSH.get())) {
            RigidCatenary rigidCatenary = MSDMinecraftClientData.getInstance().getFacingRigidCatenary(pos);
            if (rigidCatenary == null) {
                return ActionResult.FAIL;
            }
            MSDClientPacketHelper.openRigidCatenaryShapeModifierScreen(rigidCatenary.getHexId());
            return ActionResult.SUCCESS;
        }
        return ActionResult.FAIL;
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        int quadrant = Angle.getQuadrant((float)ctx.getPlayerYaw(), (boolean)true);
        return this.getDefaultState2().with(new Property((net.minecraft.state.Property)BlockRigidCatenaryNode.FACING.data), (Comparable)Boolean.valueOf(quadrant % 8 >= 4)).with(new Property((net.minecraft.state.Property)BlockRigidCatenaryNode.IS_45.data), (Comparable)Boolean.valueOf(quadrant % 4 >= 2)).with(new Property((net.minecraft.state.Property)BlockRigidCatenaryNode.IS_22_5.data), (Comparable)Boolean.valueOf(quadrant % 2 >= 1)).with(new Property((net.minecraft.state.Property)BlockRigidCatenaryNode.IS_CONNECTED.data), (Comparable)Boolean.valueOf(false));
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        super.addBlockProperties(properties);
        properties.add((HolderBase<?>)FACING);
        properties.add((HolderBase<?>)IS_22_5);
        properties.add((HolderBase<?>)IS_45);
    }

    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!world.isClient()) {
            MSDPacketDeleteData.sendDirectlyToServerCatenaryNodePosition(ServerWorld.cast((HolderBase)world), Init.blockPosToPosition((BlockPos)pos));
        }
    }

    public static float getAngle(BlockState state) {
        return (float)(IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)FACING) ? 0 : 90) + (IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)IS_22_5) ? 22.5f : 0.0f) + (float)(IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)IS_45) ? 45 : 0);
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockRigidCatenaryNodeEntity(blockPos, blockState);
    }

    public static class BlockRigidCatenaryNodeEntity
    extends BlockNodeBase.BlockNodeBaseEntity {
        public BlockRigidCatenaryNodeEntity(BlockPos blockPos, BlockState blockState) {
            super(BlockEntityTypes.RIGID_CATENARY_NODE.get(), blockPos, blockState);
        }
    }
}

