/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.client;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import org.mtr.core.data.Position;
import org.mtr.core.data.TwoPositionsBase;
import org.mtr.libraries.com.logisticscraft.occlusionculling.util.Vec3d;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectSet;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.mapper.EntityHelper;
import org.mtr.mapping.mapper.MinecraftClientHelper;
import org.mtr.mod.Init;
import top.mcmtr.core.data.Catenary;
import top.mcmtr.core.data.MSDClientData;
import top.mcmtr.core.data.RigidCatenary;
import top.mcmtr.mod.blocks.BlockRigidCatenaryNode;

public final class MSDMinecraftClientData
extends MSDClientData {
    public final Object2ObjectArrayMap<String, CatenaryWrapper> catenaryWrapperList = new Object2ObjectArrayMap();
    public final Object2ObjectArrayMap<String, RigidCatenaryWrapper> rigidCatenaryWrapperList = new Object2ObjectArrayMap();
    private static MSDMinecraftClientData instance = new MSDMinecraftClientData();

    @Override
    public void sync() {
        super.sync();
        MSDMinecraftClientData.checkAndRemoveFromMap(this.catenaryWrapperList, this.catenaries, TwoPositionsBase::getHexId);
        MSDMinecraftClientData.checkAndRemoveFromMap(this.rigidCatenaryWrapperList, this.rigidCatenaries, TwoPositionsBase::getHexId);
        this.positionsToCatenary.forEach((startPosition, catenaryMap) -> catenaryMap.forEach((endPosition, catenary) -> {
            String hexId = catenary.getHexId();
            CatenaryWrapper catenaryWrapper = (CatenaryWrapper)this.catenaryWrapperList.get((Object)hexId);
            if (catenaryWrapper == null) {
                this.catenaryWrapperList.put((Object)hexId, (Object)new CatenaryWrapper((Catenary)((Object)((Object)catenary)), hexId, (Position)startPosition, (Position)endPosition));
            } else {
                catenaryWrapper.catenary = catenary;
            }
        }));
        this.positionsToRigidCatenary.forEach((startPosition, rigidCatenaryMap) -> rigidCatenaryMap.forEach((endPosition, rigidCatenary) -> {
            String hexId = rigidCatenary.getHexId();
            RigidCatenaryWrapper rigidCatenaryWrapper = (RigidCatenaryWrapper)this.rigidCatenaryWrapperList.get((Object)hexId);
            if (rigidCatenaryWrapper == null) {
                this.rigidCatenaryWrapperList.put((Object)hexId, (Object)new RigidCatenaryWrapper((RigidCatenary)((Object)((Object)rigidCatenary)), hexId, (Position)startPosition, (Position)endPosition));
            } else {
                rigidCatenaryWrapper.rigidCatenary = rigidCatenary;
            }
        }));
    }

    public void clean() {
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity != null) {
            Position position = Init.blockPosToPosition((BlockPos)clientPlayerEntity.getBlockPos());
            int requestRadius = MinecraftClientHelper.getRenderDistance() * 16;
            this.catenaries.removeIf(catenary -> !catenary.closeTo(position, requestRadius));
            this.rigidCatenaries.removeIf(rigidCatenary -> !rigidCatenary.closeTo(position, requestRadius));
            this.sync();
        }
    }

    @Nullable
    public RigidCatenary getFacingRigidCatenary(BlockPos blockPos) {
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        ClientWorld clientWorld = minecraftClient.getWorldMapped();
        if (clientWorld == null) {
            return null;
        }
        ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
        if (clientPlayerEntity == null) {
            return null;
        }
        if (clientWorld.getBlockState((BlockPos)blockPos).getBlock().data instanceof BlockRigidCatenaryNode) {
            float playerAngle = EntityHelper.getYaw((org.mtr.mapping.holder.Entity)new org.mtr.mapping.holder.Entity((Entity)clientPlayerEntity.data)) + 90.0f;
            RigidCatenary[] closestRigidCatenary = new RigidCatenary[]{null};
            double[] closestAngle = new double[]{720.0};
            ((Object2ObjectOpenHashMap)this.positionsToRigidCatenary.getOrDefault((Object)Init.blockPosToPosition((BlockPos)blockPos), (Object)new Object2ObjectOpenHashMap())).forEach((endPosition, rigidCatenary) -> {
                double clampedAngle;
                double angle = Math.abs(Math.toDegrees(Math.atan2(endPosition.getZ() - (long)blockPos.getZ(), endPosition.getX() - (long)blockPos.getX())) - (double)playerAngle) % 360.0;
                double d = clampedAngle = angle > 180.0 ? 360.0 - angle : angle;
                if (clampedAngle < closestAngle[0]) {
                    closestRigidCatenary[0] = rigidCatenary;
                    closestAngle[0] = clampedAngle;
                }
            });
            return closestRigidCatenary[0];
        }
        return null;
    }

    public static MSDMinecraftClientData getInstance() {
        return instance;
    }

    public static void reset() {
        instance = new MSDMinecraftClientData();
    }

    private static <T, U, V> void checkAndRemoveFromMap(Map<T, U> map, ObjectSet<V> dataSet, Function<V, T> getId) {
        ObjectAVLTreeSet idSet = dataSet.stream().map(getId).collect(Collectors.toCollection(ObjectAVLTreeSet::new));
        ObjectArrayList idsToRemove = new ObjectArrayList();
        map.keySet().forEach(id -> {
            if (!idSet.contains(id)) {
                idsToRemove.add(id);
            }
        });
        idsToRemove.forEach(map::remove);
    }

    public static class RigidCatenaryWrapper {
        public boolean shouldRender;
        public final String hexId;
        public final Vec3d startVector;
        public final Vec3d endVector;
        private RigidCatenary rigidCatenary;

        public RigidCatenaryWrapper(RigidCatenary rigidCatenary, String hexId, Position startPosition, Position endPosition) {
            this.rigidCatenary = rigidCatenary;
            this.hexId = hexId;
            this.startVector = new Vec3d((double)Math.min(startPosition.getX(), endPosition.getX()), (double)Math.min(startPosition.getY(), endPosition.getY()), (double)Math.min(startPosition.getZ(), endPosition.getZ()));
            this.endVector = new Vec3d((double)Math.max(startPosition.getX(), endPosition.getX()), (double)Math.max(startPosition.getY(), endPosition.getY()), (double)Math.max(startPosition.getZ(), endPosition.getZ()));
        }

        public RigidCatenary getRigidCatenary() {
            return this.rigidCatenary;
        }
    }

    public static class CatenaryWrapper {
        public boolean shouldRender;
        public final String hexId;
        public final Vec3d startVector;
        public final Vec3d endVector;
        private Catenary catenary;

        private CatenaryWrapper(Catenary catenary, String hexId, Position startPosition, Position endPosition) {
            this.catenary = catenary;
            this.hexId = hexId;
            this.startVector = new Vec3d((double)Math.min(startPosition.getX(), endPosition.getX()), (double)Math.min(startPosition.getY(), endPosition.getY()), (double)Math.min(startPosition.getZ(), endPosition.getZ()));
            this.endVector = new Vec3d((double)Math.max(startPosition.getX(), endPosition.getX()), (double)Math.max(startPosition.getY(), endPosition.getY()), (double)Math.max(startPosition.getZ(), endPosition.getZ()));
        }

        public Catenary getCatenary() {
            return this.catenary;
        }
    }
}

