/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.packet;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonElement;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.mapper.MinecraftServerHelper;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import top.mcmtr.mod.Init;

public abstract class MSDPacketRequestResponseBase
extends PacketHandler {
    private final String content;

    public MSDPacketRequestResponseBase(PacketBufferReceiver packetBufferReceiver) {
        this.content = packetBufferReceiver.readString();
    }

    public MSDPacketRequestResponseBase(String content) {
        this.content = content;
    }

    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeString(this.content);
    }

    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        this.runServerOutbound(serverPlayerEntity.getServerWorld(), serverPlayerEntity);
    }

    public final void runClient() {
        this.runClientInbound(new JsonReader((JsonElement)Utilities.parseJson((String)this.content)));
    }

    public final void runServerOutbound(ServerWorld serverWorld, @Nullable ServerPlayerEntity serverPlayerEntity) {
        Init.sendMessageC2S(this.getKey(), serverWorld.getServer(), new org.mtr.mapping.holder.World((World)serverWorld.data), this.getDataInstance(new JsonReader((JsonElement)Utilities.parseJson((String)this.content))), this.responseType() == ResponseType.NONE ? null : responseData -> {
            JsonObject responseJson = Utilities.getJsonObjectFromData((SerializedDataBase)responseData);
            if (this.responseType() == ResponseType.PLAYER) {
                if (serverPlayerEntity != null) {
                    Init.REGISTRY.sendPacketToClient(serverPlayerEntity, (PacketHandler)this.getInstance(responseJson.toString()));
                }
            } else {
                MinecraftServerHelper.iteratePlayers((ServerWorld)serverWorld, serverPlayerEntityNew -> Init.REGISTRY.sendPacketToClient(serverPlayerEntityNew, (PacketHandler)this.getInstance(responseJson.toString())));
            }
            this.runServerInbound(serverWorld, responseJson);
        }, SerializedDataBase.class);
    }

    protected abstract void runServerInbound(ServerWorld var1, JsonObject var2);

    protected abstract void runClientInbound(JsonReader var1);

    protected abstract MSDPacketRequestResponseBase getInstance(String var1);

    protected abstract SerializedDataBase getDataInstance(JsonReader var1);

    @Nonnull
    protected abstract String getKey();

    protected abstract ResponseType responseType();

    protected static enum ResponseType {
        NONE,
        PLAYER,
        ALL;

    }
}

