/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.screen;

import net.minecraft.client.gui.widget.Widget;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import top.mcmtr.mod.InitClient;
import top.mcmtr.mod.blocks.BlockCustomTextBase;
import top.mcmtr.mod.packet.MSDPacketUpdateCustomText;

public class CustomTextScreen
extends ScreenExtension
implements IGui {
    private final BlockPos blockPos;
    private final String[] messages;
    private final TextFieldWidgetExtension[] textFieldMessages;
    private final int maxArrivals;
    private final MutableText messageText = TextHelper.translatable((String)"gui.msd.custom_text", (Object[])new Object[0]);
    private static final int MAX_MESSAGE_LENGTH = 2048;

    public CustomTextScreen(BlockPos blockPos, int maxArrivals) {
        BlockEntity blockEntity;
        this.blockPos = blockPos;
        this.maxArrivals = maxArrivals;
        this.messages = new String[maxArrivals];
        for (int i = 0; i < maxArrivals; ++i) {
            this.messages[i] = "";
        }
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld != null && (blockEntity = clientWorld.getBlockEntity(blockPos)) != null) {
            for (int i = 0; i < maxArrivals; ++i) {
                this.messages[i] = ((BlockCustomTextBase.BlockCustomTextEntity)((Object)blockEntity.data)).getMessage(i);
            }
        }
        this.textFieldMessages = new TextFieldWidgetExtension[maxArrivals];
        for (int i = 0; i < maxArrivals; ++i) {
            this.textFieldMessages[i] = new TextFieldWidgetExtension(0, 0, 0, 20, 2048, TextCase.DEFAULT, null, "");
        }
    }

    protected void init2() {
        super.init2();
        for (int i = 0; i < this.maxArrivals; ++i) {
            int y = 20 * (i + 2);
            TextFieldWidgetExtension textFieldMessage = this.textFieldMessages[i];
            IDrawing.setPositionAndWidth((TextFieldWidgetExtension)textFieldMessage, (int)22, (int)y, (int)(this.field_230708_k_ - 20));
            textFieldMessage.setText2(this.messages[i]);
            this.addChild(new ClickableWidget((Widget)textFieldMessage));
        }
    }

    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphicsHolder);
        graphicsHolder.drawText(this.messageText, 20, 20, -1, false, GraphicsHolder.getDefaultLight());
        super.render(graphicsHolder, mouseX, mouseY, delta);
    }

    public boolean isPauseScreen2() {
        return false;
    }

    public void onClose2() {
        for (int i = 0; i < this.maxArrivals; ++i) {
            this.messages[i] = this.textFieldMessages[i].getText2();
            InitClient.REGISTRY_CLIENT.sendPacketToServer((PacketHandler)new MSDPacketUpdateCustomText(this.blockPos, this.messages));
        }
        super.onClose2();
    }
}

