/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.render;

import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.RenderRails;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.mcmtr.mod.blocks.BlockCatenaryWithModel;

public final class RenderCatenaryModel<T extends BlockCatenaryWithModel.BlockCatenaryWithModelEntity>
extends BlockEntityRenderer<T> {
    private final BlockCatenaryWithModel.CatenaryModel model;

    public RenderCatenaryModel(BlockEntityRenderer.Argument argument, BlockCatenaryWithModel.CatenaryModel model) {
        super(argument);
        this.model = model;
    }

    public void render(T blockEntity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)blockEntity.getPos2().getX(), (double)blockEntity.getPos2().getY(), 0.5 + (double)blockEntity.getPos2().getZ());
        if (RenderRails.isHoldingRailRelated((ClientPlayerEntity)clientPlayerEntity) && minecraftClient.getCurrentScreenMapped() == null) {
            MainRenderer.scheduleRender((Identifier)new Identifier("mtrsteamloco", "textures/item/eye_candy.png"), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.INTERIOR, (graphicsHolderNew, offset) -> {
                storedMatrixTransformations.transform(graphicsHolderNew, offset);
                graphicsHolderNew.translate(0.0, 0.5, 0.0);
                InitClient.transformToFacePlayer((GraphicsHolder)graphicsHolderNew, (double)((double)blockEntity.getPos2().getX() + 0.5), (double)((double)blockEntity.getPos2().getY() + 0.5), (double)((double)blockEntity.getPos2().getZ() + 0.5));
                IDrawing.drawTexture((GraphicsHolder)graphicsHolderNew, (float)-0.5f, (float)-0.5f, (float)1.0f, (float)1.0f, (Direction)Direction.UP, (int)GraphicsHolder.getDefaultLight());
                graphicsHolderNew.pop();
            });
        }
        BlockPos blockPos = blockEntity.getPos2();
        Direction facing = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (DirectionProperty)BlockCatenaryWithModel.FACING);
        String modelId = this.model.getModelId();
        if (modelId != null) {
            CustomResourceLoader.getObjectById((String)modelId, objectResource -> {
                StoredMatrixTransformations storedMatrixTransformationsNew = storedMatrixTransformations.copy();
                storedMatrixTransformationsNew.add(graphicsHolderNew -> {
                    graphicsHolderNew.translate(blockEntity.getOffsetPosition().getX(), blockEntity.getOffsetPosition().getY(), blockEntity.getOffsetPosition().getZ());
                    graphicsHolderNew.rotateYDegrees(180.0f - facing.asRotation());
                    graphicsHolderNew.rotateXDegrees((float)blockEntity.getRotation().getX() + 180.0f);
                    graphicsHolderNew.rotateYDegrees((float)blockEntity.getRotation().getY());
                    graphicsHolderNew.rotateZDegrees((float)blockEntity.getRotation().getZ());
                });
                objectResource.render(storedMatrixTransformationsNew, light);
            });
        }
    }

    public boolean isInRenderDistance(BlockCatenaryWithModel.BlockCatenaryWithModelEntity blockEntity, Vector3d position) {
        return true;
    }
}

