/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.screen;

import net.minecraft.class_339;
import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.SliderWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mod.Init;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.screen.WidgetShorterSlider;
import top.mcmtr.core.data.Catenary;
import top.mcmtr.core.data.OffsetPosition;
import top.mcmtr.core.operation.MSDResetDataRequest;
import top.mcmtr.mod.InitClient;
import top.mcmtr.mod.blocks.BlockCatenaryNode;
import top.mcmtr.mod.client.MSDMinecraftClientData;
import top.mcmtr.mod.packet.MSDPacketResetData;
import top.mcmtr.mod.packet.MSDPacketUpdateCatenaryNode;

public class CatenaryScreen
extends ScreenExtension
implements IGui {
    private boolean needUpdate = false;
    private final boolean isConnected;
    private final BlockPos blockPos;
    private final OffsetPosition offsetPosition;
    private final WidgetShorterSlider sliderPositionX;
    private final WidgetShorterSlider sliderPositionY;
    private final WidgetShorterSlider sliderPositionZ;
    private static final int BUTTON_WIDTH = 60;
    private static final int BUTTON_HEIGHT = 14;

    public CatenaryScreen(boolean isConnected, BlockPos blockPos) {
        BlockEntity blockEntity;
        this.isConnected = isConnected;
        this.blockPos = blockPos;
        this.offsetPosition = new OffsetPosition(0.0, 0.0, 0.0);
        ClientWorld world = MinecraftClient.getInstance().getWorldMapped();
        if (world != null && (blockEntity = world.getBlockEntity(blockPos)) != null) {
            OffsetPosition temp = ((BlockCatenaryNode.BlockCatenaryNodeEntity)((Object)blockEntity.data)).getOffsetPosition();
            this.offsetPosition.setX(temp.getX());
            this.offsetPosition.setY(temp.getY());
            this.offsetPosition.setZ(temp.getZ());
        }
        this.sliderPositionX = new WidgetShorterSlider(0, 0, 16, num -> String.format("%d", num - 8), value -> this.updateMinecraftClientData());
        this.sliderPositionY = new WidgetShorterSlider(0, 0, 16, num -> String.format("%d", num - 8), value -> this.updateMinecraftClientData());
        this.sliderPositionZ = new WidgetShorterSlider(0, 0, 16, num -> String.format("%d", num - 8), value -> this.updateMinecraftClientData());
    }

    protected void init2() {
        super.init2();
        int i = 1;
        IDrawing.setPositionAndWidth((SliderWidgetExtension)this.sliderPositionX, (int)(this.field_22789 - 200 - 60), (int)(24 * i++ + 20), (int)(54 - GraphicsHolder.getTextWidth((String)"-8") + 180));
        IDrawing.setPositionAndWidth((SliderWidgetExtension)this.sliderPositionY, (int)(this.field_22789 - 200 - 60), (int)(24 * i++ + 20), (int)(54 - GraphicsHolder.getTextWidth((String)"-8") + 180));
        IDrawing.setPositionAndWidth((SliderWidgetExtension)this.sliderPositionZ, (int)(this.field_22789 - 200 - 60), (int)(24 * i + 20), (int)(54 - GraphicsHolder.getTextWidth((String)"-8") + 180));
        this.sliderPositionX.setHeight(14);
        this.sliderPositionY.setHeight(14);
        this.sliderPositionZ.setHeight(14);
        this.sliderPositionX.setValue((int)(this.offsetPosition.getX() * 16.0 + 8.0));
        this.sliderPositionY.setValue((int)(this.offsetPosition.getY() * 16.0 + 8.0));
        this.sliderPositionZ.setValue((int)(this.offsetPosition.getZ() * 16.0 + 8.0));
        this.addChild(new ClickableWidget((class_339)this.sliderPositionX));
        this.addChild(new ClickableWidget((class_339)this.sliderPositionY));
        this.addChild(new ClickableWidget((class_339)this.sliderPositionZ));
    }

    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphicsHolder);
        graphicsHolder.drawCenteredText(TextHelper.translatable((String)"gui.msd.catenary_offset", (Object[])new Object[0]), this.field_22789 / 2, 6, -1);
        int i = 1;
        graphicsHolder.drawText(TextHelper.translatable((String)"options.msd.catenary_offset_x", (Object[])new Object[0]), 20, 24 * i++ + 20 + 6, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(TextHelper.translatable((String)"options.msd.catenary_offset_y", (Object[])new Object[0]), 20, 24 * i++ + 20 + 6, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(TextHelper.translatable((String)"options.msd.catenary_offset_z", (Object[])new Object[0]), 20, 24 * i++ + 20 + 6, -1, false, GraphicsHolder.getDefaultLight());
        if (this.isConnected) {
            graphicsHolder.drawCenteredText(TextHelper.translatable((String)"gui.msd.shift_modify_offset", (Object[])new Object[0]), this.field_22789 / 2, 24 * i + 20 + 6, -1);
        }
        super.render(graphicsHolder, mouseX, mouseY, delta);
    }

    public boolean isPauseScreen2() {
        return false;
    }

    public void onClose2() {
        super.onClose2();
        this.offsetPosition.setX((double)(this.sliderPositionX.getIntValue() - 8) / 16.0);
        this.offsetPosition.setY((double)(this.sliderPositionY.getIntValue() - 8) / 16.0);
        this.offsetPosition.setZ((double)(this.sliderPositionZ.getIntValue() - 8) / 16.0);
        InitClient.REGISTRY_CLIENT.sendPacketToServer((PacketHandler)new MSDPacketUpdateCatenaryNode(this.blockPos, this.offsetPosition));
        if (this.needUpdate) {
            Position position = Init.blockPosToPosition((BlockPos)this.blockPos);
            InitClient.REGISTRY_CLIENT.sendPacketToServer((PacketHandler)new MSDPacketResetData(new MSDResetDataRequest(MSDMinecraftClientData.getInstance()).addCatenaryNodePosition(position).addOffsetPosition(this.offsetPosition)));
        }
    }

    private void updateMinecraftClientData() {
        if (this.isConnected) {
            this.needUpdate = true;
            OffsetPosition offsetPositionTemp = new OffsetPosition((double)(this.sliderPositionX.getIntValue() - 8) / 16.0, (double)(this.sliderPositionY.getIntValue() - 8) / 16.0, (double)(this.sliderPositionZ.getIntValue() - 8) / 16.0);
            MSDMinecraftClientData clientData = MSDMinecraftClientData.getInstance();
            Position position = Init.blockPosToPosition((BlockPos)this.blockPos);
            ((Object2ObjectOpenHashMap)clientData.positionsToCatenary.get((Object)position)).forEach((endPosition, catenary) -> {
                clientData.catenaries.remove((Object)catenary);
                clientData.catenaries.add((Object)Catenary.copy(catenary, position.equals((Object)catenary.getPosition1()) ? offsetPositionTemp : catenary.getOffsetPositionStart(), position.equals((Object)catenary.getPosition2()) ? offsetPositionTemp : catenary.getOffsetPositionEnd()));
            });
            clientData.sync();
        }
    }
}

