/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mtr.core.servlet.QueueObject;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import top.mcmtr.core.simulation.MSDSimulator;

public class MSDMain {
    private final ObjectImmutableList<MSDSimulator> simulators;
    private final ScheduledExecutorService scheduledExecutorService;
    public static final int MILLISECONDS_PER_TICK = 10;
    public static final Logger MSD_CORE_LOG = LogManager.getLogger((String)"MSD_SERVER_LOGGER");

    public MSDMain(Path rootPath, boolean threadedSimulation, String ... dimensions) {
        ObjectArrayList tempSimulators = new ObjectArrayList();
        MSD_CORE_LOG.info("MSD server Loading files...");
        for (String dimension : dimensions) {
            tempSimulators.add((Object)new MSDSimulator(dimension, rootPath));
        }
        this.simulators = new ObjectImmutableList((ObjectList)tempSimulators);
        if (threadedSimulation) {
            this.scheduledExecutorService = Executors.newScheduledThreadPool(this.simulators.size());
            this.simulators.forEach(simulator -> this.scheduledExecutorService.scheduleAtFixedRate(simulator::tick, 0L, 10L, TimeUnit.MILLISECONDS));
        } else {
            this.scheduledExecutorService = null;
        }
        MSD_CORE_LOG.info("MSD server started with dimensions {}", (Object)Arrays.toString(dimensions));
    }

    public void manualTick() {
        this.simulators.forEach(MSDSimulator::tick);
    }

    public void sendMessageC2S(@Nullable Integer worldIndex, QueueObject queueObject) {
        if (worldIndex == null) {
            this.simulators.forEach(simulator -> simulator.sendMessageC2S(queueObject));
        } else if (worldIndex >= 0 && worldIndex < this.simulators.size()) {
            ((MSDSimulator)this.simulators.get(worldIndex.intValue())).sendMessageC2S(queueObject);
        }
    }

    public void save() {
        this.simulators.forEach(MSDSimulator::save);
    }

    public void stop() {
        MSD_CORE_LOG.info("MSD stopping...");
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
            Utilities.awaitTermination((ExecutorService)this.scheduledExecutorService);
        }
        MSD_CORE_LOG.info("MSD starting full save...");
        this.simulators.forEach(MSDSimulator::stop);
        MSD_CORE_LOG.info("MSD stopped");
    }
}

