/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;
import top.mcmtr.mod.BlockEntityTypes;
import top.mcmtr.mod.Blocks;
import top.mcmtr.mod.Init;
import top.mcmtr.mod.config.Config;
import top.mcmtr.mod.packet.MSDPacketOpenBlockEntityScreen;

public final class BlockYamanoteRailwaySign
extends BlockExtension
implements IBlock,
DirectionHelper,
BlockWithEntity {
    public final int length;
    public final boolean isOdd;
    public static final float SMALL_SIGN_PERCENTAGE = 0.75f;

    public BlockYamanoteRailwaySign(int length, boolean isOdd) {
        super(org.mtr.mod.Blocks.createDefaultBlockSettings((boolean)true, blockState -> 15));
        this.length = length;
        this.isOdd = isOdd;
    }

    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingBrush((World)world, (PlayerEntity)player, () -> {
            BlockPos checkPos;
            Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
            Direction hitSide = hit.getSide();
            if ((hitSide == facing || hitSide == facing.getOpposite()) && (checkPos = this.findEndWithDirection(world, pos, hitSide.getOpposite(), false)) != null) {
                Init.REGISTRY.sendPacketToClient(ServerPlayerEntity.cast((HolderBase)player), (PacketHandler)new MSDPacketOpenBlockEntityScreen(checkPos));
            }
        });
    }

    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        boolean isNext;
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        boolean bl = isNext = direction == facing.rotateYClockwise() || state.isOf(Blocks.YAMANOTE_RAILWAY_SIGN_MIDDLE.get()) && direction == facing.rotateYCounterclockwise();
        if (isNext && !(neighborState.getBlock().data instanceof BlockYamanoteRailwaySign)) {
            return org.mtr.mapping.holder.Blocks.getAirMapped().getDefaultState();
        }
        return state;
    }

    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction facing = ctx.getPlayerFacing();
        return IBlock.isReplaceable((ItemPlacementContext)ctx, (Direction)facing.rotateYClockwise(), (int)(this.getMiddleLength() + 2)) ? this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)BlockYamanoteRailwaySign.FACING.data), (Comparable)facing.data) : null;
    }

    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        BlockPos checkPos = this.findEndWithDirection(world, pos, facing, true);
        if (checkPos != null) {
            IBlock.onBreakCreative((World)world, (PlayerEntity)player, (BlockPos)checkPos);
        }
        super.onBreak2(world, pos, state, player);
    }

    public void onPlaced2(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!world.isClient()) {
            Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
            for (int i = 1; i <= this.getMiddleLength(); ++i) {
                world.setBlockState(pos.offset(facing.rotateYClockwise(), i), Blocks.YAMANOTE_RAILWAY_SIGN_MIDDLE.get().getDefaultState().with(new org.mtr.mapping.holder.Property((Property)BlockYamanoteRailwaySign.FACING.data), (Comparable)facing.data), 3);
            }
            world.setBlockState(pos.offset(facing.rotateYClockwise(), this.getMiddleLength() + 1), this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)BlockYamanoteRailwaySign.FACING.data), (Comparable)facing.getOpposite().data), 3);
            world.updateNeighbors(pos, org.mtr.mapping.holder.Blocks.getAirMapped());
            state.updateNeighbors(new WorldAccess((LevelAccessor)world.data), pos, 3);
        }
    }

    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        if (state.isOf(Blocks.YAMANOTE_RAILWAY_SIGN_MIDDLE.get())) {
            return IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)12.0, (double)9.0, (Direction)facing);
        }
        int xStart = this.getXStart();
        VoxelShape main = IBlock.getVoxelShapeByDirection((double)((double)xStart - 0.75), (double)0.0, (double)7.0, (double)16.0, (double)12.0, (double)9.0, (Direction)facing);
        VoxelShape pole = IBlock.getVoxelShapeByDirection((double)(xStart - 2), (double)0.0, (double)7.0, (double)((double)xStart - 0.75), (double)16.0, (double)9.0, (Direction)facing);
        return VoxelShapes.union((VoxelShape)main, (VoxelShape)pole);
    }

    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING);
    }

    @Nonnull
    public String getTranslationKey2() {
        return "block.msd.yamanote_railway_sign";
    }

    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        tooltip.add(TextHelper.translatable((String)"tooltip.mtr.railway_sign_length", (Object[])new Object[]{this.length}).formatted(TextFormatting.GRAY));
        tooltip.add(TextHelper.translatable((String)(this.isOdd ? "tooltip.mtr.railway_sign_odd" : "tooltip.mtr.railway_sign_even"), (Object[])new Object[0]).formatted(TextFormatting.GRAY));
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        if (this == Blocks.YAMANOTE_RAILWAY_SIGN_MIDDLE.get().data) {
            return null;
        }
        return new BlockYamanoteRailwaySignEntity(this.length, this.isOdd, blockPos, blockState);
    }

    public int getXStart() {
        switch (this.length % 4) {
            default: {
                return this.isOdd ? 8 : 16;
            }
            case 1: {
                return this.isOdd ? 4 : 12;
            }
            case 2: {
                return this.isOdd ? 16 : 8;
            }
            case 3: 
        }
        return this.isOdd ? 12 : 4;
    }

    private int getMiddleLength() {
        return (this.length - (4 - this.getXStart() / 4)) / 2;
    }

    private BlockPos findEndWithDirection(World world, BlockPos startPos, Direction direction, boolean allowOpposite) {
        int i = 0;
        while (true) {
            BlockPos checkPos = startPos.offset(direction.rotateYCounterclockwise(), i);
            BlockState checkState = world.getBlockState(checkPos);
            if (checkState.getBlock().data instanceof BlockYamanoteRailwaySign) {
                Direction facing = IBlock.getStatePropertySafe((BlockState)checkState, (DirectionProperty)FACING);
                if (!checkState.isOf(Blocks.YAMANOTE_RAILWAY_SIGN_MIDDLE.get()) && (facing == direction || allowOpposite && facing == direction.getOpposite())) {
                    return checkPos;
                }
            } else {
                return null;
            }
            ++i;
        }
    }

    public static class BlockYamanoteRailwaySignEntity
    extends BlockEntityExtension {
        private final LongAVLTreeSet selectedIds;
        private final String[] signIds;
        private static final String KEY_SELECTED_IDS = "yamanote_selected_ids";
        private static final String KEY_SIGN_LENGTH = "yamanote_sign_length";

        public BlockYamanoteRailwaySignEntity(int length, boolean isOdd, BlockPos pos, BlockState state) {
            super(BlockYamanoteRailwaySignEntity.getType(length, isOdd), pos, state);
            this.signIds = new String[length];
            this.selectedIds = new LongAVLTreeSet();
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            this.selectedIds.clear();
            Arrays.stream(compoundTag.getLongArray(KEY_SELECTED_IDS)).forEach(arg_0 -> ((LongAVLTreeSet)this.selectedIds).add(arg_0));
            for (int i = 0; i < this.signIds.length; ++i) {
                String signId = compoundTag.getString(KEY_SIGN_LENGTH + i);
                this.signIds[i] = signId.isEmpty() ? null : signId.toLowerCase(Locale.ENGLISH);
            }
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putLongArray(KEY_SELECTED_IDS, new ArrayList(this.selectedIds));
            for (int i = 0; i < this.signIds.length; ++i) {
                compoundTag.putString(KEY_SIGN_LENGTH + i, this.signIds[i] == null ? "" : this.signIds[i]);
            }
        }

        public void setData(LongAVLTreeSet selectedIds, String[] signTypes) {
            this.selectedIds.clear();
            this.selectedIds.addAll((LongCollection)selectedIds);
            if (this.signIds.length == signTypes.length) {
                System.arraycopy(signTypes, 0, this.signIds, 0, signTypes.length);
            }
            this.markDirty2();
        }

        public LongAVLTreeSet getSelectedIds() {
            return this.selectedIds;
        }

        public String[] getSignIds() {
            return this.signIds;
        }

        private static BlockEntityType<? extends BlockEntityExtension> getType(int length, boolean isOdd) {
            switch (length) {
                case 2: {
                    return isOdd ? BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_2_ODD.get() : BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_2_EVEN.get();
                }
                case 3: {
                    return isOdd ? BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_3_ODD.get() : BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_3_EVEN.get();
                }
                case 4: {
                    return isOdd ? BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_4_ODD.get() : BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_4_EVEN.get();
                }
                case 5: {
                    return isOdd ? BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_5_ODD.get() : BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_5_EVEN.get();
                }
                case 6: {
                    return isOdd ? BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_6_ODD.get() : BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_6_EVEN.get();
                }
                case 7: {
                    return isOdd ? BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_7_ODD.get() : BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_7_EVEN.get();
                }
            }
            return BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_2_EVEN.get();
        }

        public double getRenderDistance2() {
            return Config.getYamanoteRailwaySignMaxViewDistance();
        }
    }
}

