/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.items;

import javax.annotation.Nullable;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.ItemUsageContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.ItemExtension;
import org.mtr.mapping.tool.HolderBase;
import top.mcmtr.core.data.CatenaryType;
import top.mcmtr.mod.blocks.BlockNodeBase;

public abstract class ItemBlockClickingBase
extends ItemExtension {
    protected final boolean isConnector;
    protected final CatenaryType catenaryType;
    public static final String TAG_POS = "catenary_pos";

    public ItemBlockClickingBase(ItemSettings itemSettings, boolean isConnector, CatenaryType catenaryType) {
        super(itemSettings);
        this.isConnector = isConnector;
        this.catenaryType = catenaryType;
    }

    public ActionResult useOnBlock2(ItemUsageContext context) {
        if (!context.getWorld().isClient()) {
            if (this.clickCondition(context)) {
                CompoundTag compoundTag = context.getStack().getOrCreateTag();
                if (compoundTag.contains(TAG_POS)) {
                    BlockPos posEnd = BlockPos.fromLong((long)compoundTag.getLong(TAG_POS));
                    this.onEndClick(context, posEnd, compoundTag);
                    compoundTag.remove(TAG_POS);
                } else {
                    compoundTag.putLong(TAG_POS, context.getBlockPos().asLong());
                }
                return ActionResult.SUCCESS;
            }
            return ActionResult.FAIL;
        }
        return super.useOnBlock2(context);
    }

    protected void onEndClick(ItemUsageContext context, BlockPos posEnd, CompoundTag compoundTag) {
        World world = context.getWorld();
        BlockPos posStart = context.getBlockPos();
        BlockState stateStart = world.getBlockState(posStart);
        BlockState stateEnd = world.getBlockState(posEnd);
        PlayerEntity player = context.getPlayer();
        if (ServerPlayerEntity.isInstance((HolderBase)player) && stateEnd.getBlock().data instanceof BlockNodeBase) {
            if (this.isConnector) {
                if (!posStart.equals((Object)posEnd)) {
                    this.onConnect(world, context.getStack(), stateStart, stateEnd, posStart, posEnd, this.catenaryType, ServerPlayerEntity.cast((HolderBase)player));
                }
            } else {
                this.onRemove(world, posStart, posEnd, ServerPlayerEntity.cast((HolderBase)player));
            }
        }
    }

    protected abstract void onConnect(World var1, ItemStack var2, BlockState var3, BlockState var4, BlockPos var5, BlockPos var6, CatenaryType var7, @Nullable ServerPlayerEntity var8);

    protected abstract void onRemove(World var1, BlockPos var2, BlockPos var3, @Nullable ServerPlayerEntity var4);

    protected boolean clickCondition(ItemUsageContext context) {
        World world = context.getWorld();
        Block blockStart = world.getBlockState(context.getBlockPos()).getBlock();
        return blockStart.data instanceof BlockNodeBase;
    }
}

