/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.items;

import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.core.data.Position;
import org.mtr.core.data.TwoPositionsBase;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Init;
import top.mcmtr.core.data.Catenary;
import top.mcmtr.core.data.CatenaryType;
import top.mcmtr.core.data.OffsetPosition;
import top.mcmtr.mod.blocks.BlockNodeBase;
import top.mcmtr.mod.items.ItemBlockClickingBase;
import top.mcmtr.mod.packet.MSDPacketDeleteData;
import top.mcmtr.mod.packet.MSDPacketUpdateData;

public final class ItemCatenaryConnector
extends ItemBlockClickingBase {
    public ItemCatenaryConnector(ItemSettings itemSettings, boolean isConnector, CatenaryType catenaryType) {
        super(itemSettings, isConnector, catenaryType);
    }

    @Override
    protected void onConnect(World world, ItemStack stack, BlockState stateStart, BlockState stateEnd, BlockPos posStart, BlockPos posEnd, CatenaryType catenaryType, @Nullable ServerPlayerEntity player) {
        if (catenaryType != null) {
            Position positionEnd;
            BlockNodeBase.BlockNodeBaseEntity startBlockEntity = (BlockNodeBase.BlockNodeBaseEntity)((Object)world.getBlockEntity((BlockPos)posStart).data);
            BlockNodeBase.BlockNodeBaseEntity endBlockEntity = (BlockNodeBase.BlockNodeBaseEntity)((Object)world.getBlockEntity((BlockPos)posEnd).data);
            OffsetPosition offsetPositionStart = startBlockEntity.getOffsetPosition();
            OffsetPosition offsetPositionEnd = endBlockEntity.getOffsetPosition();
            Position positionStart = Init.blockPosToPosition((BlockPos)posStart);
            if (Catenary.verifyPosition(positionStart, positionEnd = Init.blockPosToPosition((BlockPos)posEnd), offsetPositionStart, offsetPositionEnd)) {
                Catenary catenary = new Catenary(positionStart, positionEnd, offsetPositionStart, offsetPositionEnd, catenaryType);
                world.setBlockState(posStart, stateStart.with(new org.mtr.mapping.holder.Property((Property)BlockNodeBase.IS_CONNECTED.data), (Comparable)Boolean.valueOf(true)));
                world.setBlockState(posEnd, stateEnd.with(new org.mtr.mapping.holder.Property((Property)BlockNodeBase.IS_CONNECTED.data), (Comparable)Boolean.valueOf(true)));
                MSDPacketUpdateData.sendDirectlyToServerCatenary(ServerWorld.cast((HolderBase)world), catenary);
            }
        }
    }

    @Override
    protected void onRemove(World world, BlockPos posStart, BlockPos posEnd, @Nullable ServerPlayerEntity player) {
        MSDPacketDeleteData.sendDirectlyToServerCatenaryId(ServerWorld.cast((HolderBase)world), TwoPositionsBase.getHexId((Position)Init.blockPosToPosition((BlockPos)posStart), (Position)Init.blockPosToPosition((BlockPos)posEnd)));
    }
}

