/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.render;

import java.util.Comparator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.mtr.core.data.NameColorDataBase;
import org.mtr.core.data.Station;
import org.mtr.core.data.StationExit;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntObjectImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.client.DynamicTextureCache;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import org.mtr.mod.resource.SignResource;
import org.mtr.mod.screen.EditStationScreen;
import top.mcmtr.mod.InitClient;
import top.mcmtr.mod.blocks.BlockYamanoteRailwaySign;
import top.mcmtr.mod.config.Config;

public class RenderYamanoteRailwaySign<T extends BlockYamanoteRailwaySign.BlockYamanoteRailwaySignEntity>
extends BlockEntityRenderer<T>
implements IBlock,
IGui,
IDrawing {
    public RenderYamanoteRailwaySign(BlockEntityRenderer.Argument argument) {
        super(argument);
    }

    public void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = entity.getWorld2();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.getPos2();
        BlockState state = world.getBlockState(pos);
        if (!(state.getBlock().data instanceof BlockYamanoteRailwaySign)) {
            return;
        }
        BlockYamanoteRailwaySign block = (BlockYamanoteRailwaySign)((Object)state.getBlock().data);
        if (((BlockYamanoteRailwaySign.BlockYamanoteRailwaySignEntity)((Object)entity)).getSignIds().length != block.length) {
            return;
        }
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)BlockYamanoteRailwaySign.FACING);
        String[] signIds = ((BlockYamanoteRailwaySign.BlockYamanoteRailwaySignEntity)((Object)entity)).getSignIds();
        int backgroundColor = 0;
        for (String signId : signIds) {
            SignResource sign;
            if (signId == null || (sign = RenderYamanoteRailwaySign.getSign(signId)) == null || sign.getBackgroundColor() == 0) continue;
            backgroundColor = sign.getBackgroundColor();
            break;
        }
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)entity.getPos2().getX(), 0.53125 + (double)entity.getPos2().getY(), 0.5 + (double)entity.getPos2().getZ());
        storedMatrixTransformations.add(graphicsHolderNew -> {
            graphicsHolderNew.rotateYDegrees(-facing.asRotation());
            graphicsHolderNew.rotateZDegrees(180.0f);
            graphicsHolderNew.translate((double)((float)block.getXStart() / 16.0f) - 0.5, 0.0, -0.06875000009313226);
        });
        graphicsHolder.push();
        graphicsHolder.translate(0.5, 0.53125, 0.5);
        graphicsHolder.rotateYDegrees(-facing.asRotation());
        graphicsHolder.rotateZDegrees(180.0f);
        graphicsHolder.translate((double)((float)block.getXStart() / 16.0f) - 0.5, 0.0, -0.06875000009313226);
        if (backgroundColor != 0) {
            int newBackgroundColor = backgroundColor | 0xFF000000;
            MainRenderer.scheduleRender((Identifier)new Identifier("msd", "textures/block/white.png"), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT, (graphicsHolderNew, offset) -> {
                storedMatrixTransformations.transform(graphicsHolderNew, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolderNew, (float)0.0f, (float)0.0f, (float)0.003125f, (float)(0.5f * (float)signIds.length), (float)0.5f, (float)0.003125f, (Direction)facing, (int)newBackgroundColor, (int)GraphicsHolder.getDefaultLight());
                graphicsHolderNew.pop();
            });
        }
        for (int i = 0; i < signIds.length; ++i) {
            if (signIds[i] == null) continue;
            RenderYamanoteRailwaySign.drawSign(graphicsHolder, storedMatrixTransformations, pos, signIds[i], 0.5f * (float)i, 0.0f, 0.5f, RenderYamanoteRailwaySign.getMaxWidth(signIds, i, false), RenderYamanoteRailwaySign.getMaxWidth(signIds, i, true), ((BlockYamanoteRailwaySign.BlockYamanoteRailwaySignEntity)((Object)entity)).getSelectedIds(), facing, backgroundColor | 0xFF000000, (textureId, x, y, size, flipTexture) -> MainRenderer.scheduleRender((Identifier)textureId, (boolean)true, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolderNew, offset) -> {
                storedMatrixTransformations.transform(graphicsHolderNew, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolderNew, (float)x, (float)y, (float)size, (float)size, (float)(flipTexture ? 1.0f : 0.0f), (float)0.0f, (float)(flipTexture ? 0.0f : 1.0f), (float)1.0f, (Direction)facing, (int)-1, (int)GraphicsHolder.getDefaultLight());
                graphicsHolderNew.pop();
            }));
        }
        graphicsHolder.pop();
    }

    public static void drawSign(GraphicsHolder graphicsHolder, @Nullable StoredMatrixTransformations storedMatrixTransformations, BlockPos pos, String signId, float x, float y, float size, float maxWidthLeft, float maxWidthRight, LongAVLTreeSet selectedIds, Direction facing, int backgroundColor, DrawTexture drawTexture) {
        boolean isStation;
        SignResource sign = RenderYamanoteRailwaySign.getSign(signId);
        if (sign == null) {
            return;
        }
        float signSize = (sign.getSmall() ? 0.75f : 1.0f) * size;
        float margin = (size - signSize) / 2.0f;
        boolean hasCustomText = sign.hasCustomText;
        boolean flipCustomText = sign.getFlipCustomText();
        boolean flipTexture = sign.getFlipTexture();
        boolean isExit = signId.equals("exit_letter") || signId.equals("exit_letter_flipped");
        boolean isLine = signId.equals("line") || signId.equals("line_flipped");
        boolean isPlatform = signId.equals("platform") || signId.equals("platform_flipped");
        boolean bl = isStation = signId.equals("station") || signId.equals("station_flipped");
        if (storedMatrixTransformations != null && isExit) {
            Station station = InitClient.findStation(pos);
            if (station == null) {
                return;
            }
            ObjectArrayList selectedExitsSorted = new ObjectArrayList();
            ObjectArrayList exits = EditStationScreen.getStationExits((Station)station, (boolean)true);
            exits.forEach(exit -> {
                if (selectedIds.longStream().anyMatch(selectedId -> EditStationScreen.deserializeExit((long)selectedId).equals(exit.getName()))) {
                    selectedExitsSorted.add(exit);
                }
            });
            graphicsHolder.push();
            graphicsHolder.translate((double)(x + margin + (flipCustomText ? signSize : 0.0f)), (double)(y + margin), 0.0);
            float maxWidth = ((flipCustomText ? maxWidthLeft : maxWidthRight) + 1.0f) * size - margin * 2.0f;
            float exitWidth = signSize * (float)selectedExitsSorted.size();
            graphicsHolder.scale(Math.min(1.0f, maxWidth / exitWidth), 1.0f, 1.0f);
            for (int i = 0; i < selectedExitsSorted.size(); ++i) {
                StationExit stationExit = (StationExit)selectedExitsSorted.get(flipCustomText ? selectedExitsSorted.size() - i - 1 : i);
                float signOffset = (float)(flipCustomText ? -1 : 1) * signSize * (float)i - (flipCustomText ? signSize : 0.0f);
                MainRenderer.scheduleRender((Identifier)DynamicTextureCache.instance.getExitSignLetter((String)stationExit.getName().substring((int)0, (int)1), (String)stationExit.getName().substring((int)1), (int)backgroundColor).identifier, (boolean)true, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolderNew, offset);
                    graphicsHolderNew.translate((double)(x + margin + (flipCustomText ? signSize : 0.0f)), (double)(y + margin), 0.0);
                    graphicsHolderNew.scale(Math.min(1.0f, maxWidth / exitWidth), 1.0f, 1.0f);
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolderNew, (float)signOffset, (float)0.0f, (float)signSize, (float)signSize, (Direction)facing, (int)GraphicsHolder.getDefaultLight());
                    graphicsHolderNew.pop();
                });
                if (!(maxWidth > exitWidth) || selectedExitsSorted.size() != 1 || stationExit.getDestinations().isEmpty()) continue;
                RenderYamanoteRailwaySign.renderCustomText((String)stationExit.getDestinations().get(0), storedMatrixTransformations, facing, size, flipCustomText ? x : x + size, flipCustomText, maxWidth - exitWidth - margin * 2.0f, backgroundColor);
            }
            graphicsHolder.pop();
        } else if (storedMatrixTransformations != null && isLine) {
            Station station = InitClient.findStation(pos);
            if (station == null) {
                return;
            }
            LongAVLTreeSet platformIds = new LongAVLTreeSet();
            station.savedRails.forEach(platform -> platformIds.add(platform.getId()));
            station.connectedStations.forEach(connectingStation -> connectingStation.savedRails.forEach(platform -> platformIds.add(platform.getId())));
            ObjectArrayList selectedRoutesSorted = new ObjectArrayList();
            IntAVLTreeSet addedColors = new IntAVLTreeSet();
            MinecraftClientData.getInstance().simplifiedRoutes.forEach(simplifiedRoute -> {
                int color = simplifiedRoute.getColor();
                if (!addedColors.contains(color) && selectedIds.contains((long)color) && simplifiedRoute.getPlatforms().stream().anyMatch(simplifiedRoutePlatform -> platformIds.contains(simplifiedRoutePlatform.getPlatformId()))) {
                    selectedRoutesSorted.add((Object)new IntObjectImmutablePair(color, (Object)simplifiedRoute.getName().split("\\|\\|")[0]));
                    addedColors.add(color);
                }
            });
            selectedRoutesSorted.sort(Comparator.comparingInt(IntObjectImmutablePair::leftInt));
            float maxWidth = Math.max(0.0f, ((flipCustomText ? maxWidthLeft : maxWidthRight) + 1.0f) * size - margin * 2.0f);
            float height = size - margin * 2.0f;
            ObjectArrayList resourceLocationDataList = new ObjectArrayList();
            float totalTextWidth = 0.0f;
            for (IntObjectImmutablePair route : selectedRoutesSorted) {
                DynamicTextureCache.DynamicResource resourceLocationData = DynamicTextureCache.instance.getRouteSquare(route.leftInt(), (String)route.right(), flipCustomText ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT);
                resourceLocationDataList.add((Object)resourceLocationData);
                totalTextWidth += height * (float)resourceLocationData.width / (float)resourceLocationData.height + margin / 2.0f;
            }
            StoredMatrixTransformations storedMatrixTransformations2 = storedMatrixTransformations.copy();
            storedMatrixTransformations2.add(graphicsHolderNew -> graphicsHolderNew.translate(flipCustomText ? (double)(x + size - margin) : (double)(x + margin), 0.0, 0.0));
            if (totalTextWidth > margin / 2.0f) {
                totalTextWidth -= margin / 2.0f;
            }
            if (totalTextWidth > maxWidth) {
                float finalTotalTextWidth = totalTextWidth;
                storedMatrixTransformations2.add(graphicsHolderNew -> graphicsHolderNew.scale(maxWidth / finalTotalTextWidth, 1.0f, 1.0f));
            }
            float xOffset = 0.0f;
            for (DynamicTextureCache.DynamicResource resourceLocationData : resourceLocationDataList) {
                float width = height * (float)resourceLocationData.width / (float)resourceLocationData.height;
                float finalXOffset = xOffset;
                MainRenderer.scheduleRender((Identifier)resourceLocationData.identifier, (boolean)true, (QueuedRenderLayer)QueuedRenderLayer.LIGHT, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations2.transform(graphicsHolderNew, offset);
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolderNew, (float)(flipCustomText ? -finalXOffset - width : finalXOffset), (float)margin, (float)width, (float)height, (Direction)Direction.UP, (int)GraphicsHolder.getDefaultLight());
                    graphicsHolderNew.pop();
                });
                xOffset += width + margin / 2.0f;
            }
        } else if (storedMatrixTransformations != null && isPlatform) {
            Station station = InitClient.findStation(pos);
            if (station == null) {
                return;
            }
            LongArrayList selectedIdsSorted = station.savedRails.stream().sorted().mapToLong(NameColorDataBase::getId).filter(arg_0 -> ((LongAVLTreeSet)selectedIds).contains(arg_0)).boxed().collect(Collectors.toCollection(LongArrayList::new));
            int selectedCount = selectedIdsSorted.size();
            float extraMargin = margin - margin / (float)selectedCount;
            float height = (size - extraMargin * 2.0f) / (float)selectedCount;
            for (int i = 0; i < selectedIdsSorted.size(); ++i) {
                float topOffset = (float)i * height + extraMargin;
                float bottomOffset = (float)(i + 1) * height + extraMargin;
                float left = flipCustomText ? x - maxWidthLeft * size : x + margin;
                float right = flipCustomText ? x + size - margin : x + (maxWidthRight + 1.0f) * size;
                MainRenderer.scheduleRender((Identifier)DynamicTextureCache.instance.getDirectionArrow((long)selectedIdsSorted.getLong((int)i), (boolean)false, (boolean)false, (IGui.HorizontalAlignment)(flipCustomText ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT), (boolean)false, (float)(margin / size), (float)((right - left) / (bottomOffset - topOffset)), (int)backgroundColor, (int)-1, (int)backgroundColor).identifier, (boolean)true, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolderNew, offset);
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolderNew, (float)left, (float)topOffset, (float)0.0f, (float)right, (float)bottomOffset, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)facing, (int)-1, (int)GraphicsHolder.getDefaultLight());
                    graphicsHolderNew.pop();
                });
            }
        } else {
            drawTexture.drawTexture(sign.getTexture(), x + margin, y + margin, signSize, flipTexture);
            if (hasCustomText) {
                float start;
                float fixedMargin = size * 0.25f / 2.0f;
                boolean isSmall = sign.getSmall();
                float maxWidth = Math.max(0.0f, (flipCustomText ? maxWidthLeft : maxWidthRight) * size - fixedMargin * (float)(isSmall ? 1 : 2));
                float f = flipCustomText ? x - (isSmall ? 0.0f : fixedMargin) : (start = x + size + (isSmall ? 0.0f : fixedMargin));
                if (storedMatrixTransformations == null) {
                    IDrawing.drawStringWithFont((GraphicsHolder)graphicsHolder, (String)(isExit || isLine ? "..." : sign.getCustomText().getString()), (IGui.HorizontalAlignment)(flipCustomText ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT), (IGui.VerticalAlignment)IGui.VerticalAlignment.TOP, (float)start, (float)(y + fixedMargin), (float)maxWidth, (float)(size - fixedMargin * 2.0f), (float)0.01f, (int)-1, (boolean)false, (int)GraphicsHolder.getDefaultLight(), null);
                } else {
                    String signText = isStation ? IGui.mergeStations(selectedIds.longStream().filter(arg_0 -> ((Long2ObjectOpenHashMap)MinecraftClientData.getInstance().stationIdMap).containsKey(arg_0)).sorted().mapToObj(stationId -> IGui.insertTranslation((TranslationProvider.TranslationHolder)TranslationProvider.GUI_MTR_STATION_CJK, (TranslationProvider.TranslationHolder)TranslationProvider.GUI_MTR_STATION, (int)1, (String[])new String[]{((Station)MinecraftClientData.getInstance().stationIdMap.get(stationId)).getName()})).collect(Collectors.toList())) : sign.getCustomText().getString();
                    RenderYamanoteRailwaySign.renderCustomText(signText, storedMatrixTransformations, facing, size, start, flipCustomText, maxWidth, backgroundColor);
                }
            }
        }
    }

    private static void renderCustomText(String signText, StoredMatrixTransformations storedMatrixTransformations, Direction facing, float size, float start, boolean flipCustomText, float maxWidth, int backgroundColor) {
        DynamicTextureCache.DynamicResource dynamicResource = DynamicTextureCache.instance.getSignText(signText, flipCustomText ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT, 0.125f, backgroundColor, -1);
        float width = Math.min(size * (float)dynamicResource.width / (float)dynamicResource.height, maxWidth);
        MainRenderer.scheduleRender((Identifier)dynamicResource.identifier, (boolean)true, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolderNew, offset) -> {
            storedMatrixTransformations.transform(graphicsHolderNew, offset);
            IDrawing.drawTexture((GraphicsHolder)graphicsHolderNew, (float)(start - (flipCustomText ? width : 0.0f)), (float)0.0f, (float)0.0f, (float)(start + (flipCustomText ? 0.0f : width)), (float)size, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)facing, (int)-1, (int)GraphicsHolder.getDefaultLight());
            graphicsHolderNew.pop();
        });
    }

    public static SignResource getSign(@Nullable String signId) {
        if (signId == null) {
            return null;
        }
        SignResource[] signResource = new SignResource[]{null};
        CustomResourceLoader.getSignById((String)signId, newSignResource -> {
            signResource[0] = newSignResource;
        });
        return signResource[0];
    }

    public static float getMaxWidth(String[] signIds, int index, boolean right) {
        float maxWidthLeft = 0.0f;
        int i = index + (right ? 1 : -1);
        while (right ? i < signIds.length : i >= 0) {
            if (signIds[i] != null) {
                SignResource sign = RenderYamanoteRailwaySign.getSign(signIds[i]);
                if (sign != null && sign.hasCustomText && right == sign.getFlipCustomText()) {
                    maxWidthLeft /= 2.0f;
                }
                return maxWidthLeft;
            }
            maxWidthLeft += 1.0f;
            i += right ? 1 : -1;
        }
        return maxWidthLeft;
    }

    public int getRenderDistance2() {
        return Config.getYamanoteRailwaySignMaxViewDistance();
    }

    @FunctionalInterface
    public static interface DrawTexture {
        public void drawTexture(Identifier var1, float var2, float var3, float var4, boolean var5);
    }
}

