/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.screen;

import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import top.mcmtr.core.data.RigidCatenary;
import top.mcmtr.core.operation.MSDUpdateDataRequest;
import top.mcmtr.mod.InitClient;
import top.mcmtr.mod.client.MSDMinecraftClientData;
import top.mcmtr.mod.packet.MSDPacketUpdateData;

public class RigidCatenaryShapeModifierScreen
extends ScreenExtension
implements IGui {
    private boolean needUpdate = false;
    private RigidCatenary.Shape shape;
    private double radius;
    private final RigidCatenary rigidCatenary;
    private final double maxRadius;
    private final ButtonWidgetExtension buttonShape;
    private final ButtonWidgetExtension buttonMinus0;
    private final ButtonWidgetExtension buttonMinus1;
    private final ButtonWidgetExtension buttonMinus2;
    private final ButtonWidgetExtension buttonPlus0;
    private final ButtonWidgetExtension buttonPlus1;
    private final ButtonWidgetExtension buttonPlus2;
    private final TextFieldWidgetExtension textFieldRadius;
    private final MutableText shapeText = TextHelper.translatable((String)"gui.msd.rigid_catenary_shape", (Object[])new Object[0]);
    private final MutableText radiusText = TextHelper.translatable((String)"gui.msd.rigid_catenary_radius", (Object[])new Object[0]);
    private final int xStart;
    private static final int BUTTON_WIDTH = 320;

    public RigidCatenaryShapeModifierScreen(String rigidCatenaryId) {
        this.rigidCatenary = (RigidCatenary)((Object)MSDMinecraftClientData.getInstance().rigidCatenaryIdMap.get((Object)rigidCatenaryId));
        this.shape = this.rigidCatenary == null ? RigidCatenary.Shape.QUADRATIC : this.rigidCatenary.rigidCatenaryMath.getShape();
        this.radius = this.rigidCatenary == null ? 0.0 : this.rigidCatenary.rigidCatenaryMath.getVerticalRadius();
        this.maxRadius = this.rigidCatenary == null ? 0.0 : this.rigidCatenary.rigidCatenaryMath.getMaxVerticalRadius();
        this.buttonShape = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal((String)""), button -> {
            this.shape = this.shape == RigidCatenary.Shape.QUADRATIC ? RigidCatenary.Shape.TWO_RADII : RigidCatenary.Shape.QUADRATIC;
            this.update(this.radius, true);
        });
        this.buttonMinus2 = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal((String)"-10"), button -> this.update(this.radius - 10.0, true));
        this.buttonMinus1 = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal((String)"-1"), button -> this.update(this.radius - 1.0, true));
        this.buttonMinus0 = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal((String)"-0.1"), button -> this.update(this.radius - 0.1, true));
        this.buttonPlus0 = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal((String)"+0.1"), button -> this.update(this.radius + 0.1, true));
        this.buttonPlus1 = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal((String)"+1"), button -> this.update(this.radius + 1.0, true));
        this.buttonPlus2 = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.literal((String)"+10"), button -> this.update(this.radius + 10.0, true));
        this.textFieldRadius = new TextFieldWidgetExtension(0, 0, 0, 20, 256, TextCase.DEFAULT, "[^\\d\\.]", "0");
        this.xStart = Math.max(GraphicsHolder.getTextWidth((MutableText)this.shapeText), GraphicsHolder.getTextWidth((MutableText)this.radiusText)) + 12;
    }

    protected void init2() {
        super.init2();
        IDrawing.setPositionAndWidth((ButtonWidgetExtension)this.buttonShape, (int)this.xStart, (int)0, (int)320);
        IDrawing.setPositionAndWidth((ButtonWidgetExtension)this.buttonMinus2, (int)this.xStart, (int)22, (int)40);
        IDrawing.setPositionAndWidth((ButtonWidgetExtension)this.buttonMinus1, (int)(this.xStart + 40), (int)22, (int)40);
        IDrawing.setPositionAndWidth((ButtonWidgetExtension)this.buttonMinus0, (int)(this.xStart + 80), (int)22, (int)40);
        IDrawing.setPositionAndWidth((ButtonWidgetExtension)this.buttonPlus0, (int)(this.xStart + 320 - 120), (int)22, (int)40);
        IDrawing.setPositionAndWidth((ButtonWidgetExtension)this.buttonPlus1, (int)(this.xStart + 320 - 80), (int)22, (int)40);
        IDrawing.setPositionAndWidth((ButtonWidgetExtension)this.buttonPlus2, (int)(this.xStart + 320 - 40), (int)22, (int)40);
        IDrawing.setPositionAndWidth((TextFieldWidgetExtension)this.textFieldRadius, (int)(this.xStart + 120 + 2), (int)22, (int)76);
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonShape));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonMinus2));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonMinus1));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonMinus0));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonPlus0));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonPlus1));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonPlus2));
        this.addChild(new ClickableWidget((AbstractWidget)this.textFieldRadius));
        this.update(this.radius, false);
    }

    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        guiDrawing.beginDrawingRectangle();
        guiDrawing.drawRectangle(0.0, 0.0, (double)this.f_96543_, this.shape == RigidCatenary.Shape.QUADRATIC ? 20.0 : 44.0, -15592942);
        guiDrawing.finishDrawingRectangle();
        super.render(graphicsHolder, mouseX, mouseY, delta);
        graphicsHolder.drawText(this.shapeText, 6, 6, -1, false, GraphicsHolder.getDefaultLight());
        if (this.shape != RigidCatenary.Shape.QUADRATIC) {
            graphicsHolder.drawText(this.radiusText, 6, 28, -1, false, GraphicsHolder.getDefaultLight());
        }
    }

    public boolean isPauseScreen2() {
        return false;
    }

    public void onClose2() {
        super.onClose2();
        if (this.needUpdate) {
            InitClient.REGISTRY_CLIENT.sendPacketToServer((PacketHandler)new MSDPacketUpdateData(new MSDUpdateDataRequest(MSDMinecraftClientData.getInstance()).addRigidCatenary(RigidCatenary.copy(this.rigidCatenary, this.shape, this.radius))));
        }
    }

    private void update(double newRadius, boolean updateClient) {
        this.radius = Utilities.clamp((double)Utilities.round((double)newRadius, (int)2), (double)0.0, (double)this.maxRadius);
        this.buttonShape.setMessage2(new Text((Component)TextHelper.translatable((String)(this.shape == RigidCatenary.Shape.QUADRATIC ? "gui.msd.rigid_catenary_shape_quadratic" : "gui.msd.rigid_catenary_shape_two_radii"), (Object[])new Object[0]).data));
        this.buttonMinus2.setVisibleMapped(this.shape != RigidCatenary.Shape.QUADRATIC);
        this.buttonMinus1.setVisibleMapped(this.shape != RigidCatenary.Shape.QUADRATIC);
        this.buttonMinus0.setVisibleMapped(this.shape != RigidCatenary.Shape.QUADRATIC);
        this.buttonPlus0.setVisibleMapped(this.shape != RigidCatenary.Shape.QUADRATIC);
        this.buttonPlus1.setVisibleMapped(this.shape != RigidCatenary.Shape.QUADRATIC);
        this.buttonPlus2.setVisibleMapped(this.shape != RigidCatenary.Shape.QUADRATIC);
        this.buttonMinus2.setActiveMapped(this.radius > 0.0);
        this.buttonMinus1.setActiveMapped(this.radius > 0.0);
        this.buttonMinus0.setActiveMapped(this.radius > 0.0);
        this.buttonPlus0.setActiveMapped(this.radius < this.maxRadius);
        this.buttonPlus1.setActiveMapped(this.radius < this.maxRadius);
        this.buttonPlus2.setActiveMapped(this.radius < this.maxRadius);
        this.textFieldRadius.setVisibleMapped(this.shape != RigidCatenary.Shape.QUADRATIC);
        this.textFieldRadius.setText2(String.valueOf(this.radius));
        if (updateClient) {
            this.needUpdate = true;
            MSDMinecraftClientData clientData = MSDMinecraftClientData.getInstance();
            clientData.rigidCatenaries.remove((Object)this.rigidCatenary);
            clientData.rigidCatenaries.add((Object)RigidCatenary.copy(this.rigidCatenary, this.shape, this.radius));
            clientData.sync();
        }
    }
}

