/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod;

import org.mtr.core.data.Station;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.RenderLayer;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.MinecraftClientHelper;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.registry.RegistryClient;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.render.RenderPIDS;
import top.mcmtr.core.operation.MSDDataRequest;
import top.mcmtr.mod.BlockEntityTypes;
import top.mcmtr.mod.Blocks;
import top.mcmtr.mod.Init;
import top.mcmtr.mod.Items;
import top.mcmtr.mod.blocks.BlockCatenaryWithModel;
import top.mcmtr.mod.client.MSDMinecraftClientData;
import top.mcmtr.mod.config.Config;
import top.mcmtr.mod.packet.MSDPacketRequestData;
import top.mcmtr.mod.render.RenderCatenaryModel;
import top.mcmtr.mod.render.RenderCustomText;
import top.mcmtr.mod.render.RenderYamanoteRailwaySign;

public class InitClient {
    private static long lastMillis = 0L;
    private static long gameMillis = 0L;
    private static long lastUpdatePacketMillis = 0L;
    public static final RegistryClient REGISTRY_CLIENT = new RegistryClient(Init.REGISTRY);

    public static void init() {
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.NEW_CATENARY_NODE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.RIGID_CATENARY_NODE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_WITH_LONG);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_WITH_LONG_TOP);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_WITH_SHORT);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_WITH_SHORT_TOP);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_WITH_LONG_COUNTERWEIGHT);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_WITH_LONG_COUNTERWEIGHT_MIRROR);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_WITH_SHORT_COUNTERWEIGHT);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_WITH_SHORT_COUNTERWEIGHT_MIRROR);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_NODE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_NODE_STYLE_2);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.SHORT_CATENARY_NODE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.SHORT_CATENARY_NODE_STYLE_2);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.ELECTRIC_NODE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.TRANS_CATENARY_NODE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getTranslucent(), Blocks.SURVEILLANCE_CAMERAS);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.YUUNI_PIDS);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.YUUNI_2_PIDS);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.STANDING_SIGN);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.STANDING_SIGN_1);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.STANDING_SIGN_POLE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.YUUNI_TICKET);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.HALL_SEAT);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.YUUNI_TICKET);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.HALL_SEAT);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.DECORATION_BOOK);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.DECORATION_CEILING);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.DECORATION_CEILING_LIGHT);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.DECORATION_PC);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.DECORATION_STAIR);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.DISPLAY_BOARD_HORIZONTALLY);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.DISPLAY_BOARD_VERTICALLY);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.RAILING_STAIR_FLAT);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.RAILING_STAIR_FLAT_MIRROR);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getTranslucent(), Blocks.RAILING_STAIR_GLASS);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getTranslucent(), Blocks.RAILING_STAIR_GLASS_MIRROR);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_POLE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_POLE_TOP_MIDDLE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_POLE_TOP_SIDE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_RACK_1);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_RACK_2);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_RACK_BOTH_SIDE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_RACK_POLE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_RACK_POLE_BOTH_SIDE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.CATENARY_RACK_SIDE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.ELECTRIC_POLE_ANOTHER_SIDE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.ELECTRIC_POLE_SIDE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.ELECTRIC_POLE_TOP_BOTH_SIDE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.ELECTRIC_POLE_TOP_SIDE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.SHORT_CATENARY_RACK);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.SHORT_CATENARY_RACK_BOTH_SIDE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.SHORT_CATENARY_RACK_POLE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.SHORT_CATENARY_RACK_POLE_BOTH_SIDE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.SHORT_CATENARY_RACK_SIDE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getTranslucent(), Blocks.SURVEILLANCE_CAMERAS_WALL);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.HALL_SEAT_SIDE);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.HALL_SEAT_SIDE_MIRROR);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.RAILING_STAIR_START);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.RAILING_STAIR);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.RAILING_STAIR_END);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.RAILING_STAIR_START_MIRROR);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.RAILING_STAIR_MIRROR);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.RAILING_STAIR_END_MIRROR);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getTranslucent(), Blocks.RAILING_STAIR_GLASS_1);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getTranslucent(), Blocks.RAILING_STAIR_GLASS_2);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getTranslucent(), Blocks.RAILING_STAIR_GLASS_3);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getTranslucent(), Blocks.RAILING_STAIR_GLASS_MIRROR_1);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getTranslucent(), Blocks.RAILING_STAIR_GLASS_MIRROR_2);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getTranslucent(), Blocks.RAILING_STAIR_GLASS_MIRROR_3);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.RAILING_STAIR_CORNER);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.RAILING_STAIR_CORNER_2);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.RAILING_STAIR_CORNER_MIRROR);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getCutout(), Blocks.RAILING_STAIR_CORNER_MIRROR_2);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getTranslucent(), Blocks.RAILING_STAIR_GLASS_4);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getTranslucent(), Blocks.RAILING_STAIR_GLASS_5);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getTranslucent(), Blocks.RAILING_STAIR_GLASS_MIRROR_4);
        REGISTRY_CLIENT.registerBlockRenderType(RenderLayer.getTranslucent(), Blocks.RAILING_STAIR_GLASS_MIRROR_5);
        REGISTRY_CLIENT.registerItemModelPredicate(Items.CATENARY_CONNECTOR, new Identifier("msd", "selected"), InitClient.checkItemPredicateTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.ELECTRIC_CONNECTOR, new Identifier("msd", "selected"), InitClient.checkItemPredicateTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.RIGID_SOFT_CATENARY_CONNECTOR, new Identifier("msd", "selected"), InitClient.checkItemPredicateTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.RIGID_CATENARY_CONNECTOR, new Identifier("msd", "selected"), InitClient.checkItemPredicateTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.CATENARY_REMOVER, new Identifier("msd", "selected"), InitClient.checkItemPredicateTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.RIGID_CATENARY_REMOVER, new Identifier("msd", "selected"), InitClient.checkItemPredicateTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.SURVEILLANCE_CAMERAS, new Identifier("msd", "hold"), InitClient.checkItemHoldTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.HALL_SEAT, new Identifier("msd", "hold"), InitClient.checkItemHoldTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.DECORATION_BOOK, new Identifier("msd", "hold"), InitClient.checkItemHoldTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.DECORATION_CEILING, new Identifier("msd", "hold"), InitClient.checkItemHoldTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.DECORATION_CEILING_LIGHT, new Identifier("msd", "hold"), InitClient.checkItemHoldTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.DECORATION_FLOOR, new Identifier("msd", "hold"), InitClient.checkItemHoldTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.DECORATION_PC, new Identifier("msd", "hold"), InitClient.checkItemHoldTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.DECORATION_STAIR, new Identifier("msd", "hold"), InitClient.checkItemHoldTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.DISPLAY_BOARD_HORIZONTALLY, new Identifier("msd", "hold"), InitClient.checkItemHoldTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.DISPLAY_BOARD_VERTICALLY, new Identifier("msd", "hold"), InitClient.checkItemHoldTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.RAILING_STAIR_FLAT, new Identifier("msd", "hold"), InitClient.checkItemHoldTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.RAILING_STAIR_FLAT_MIRROR, new Identifier("msd", "hold"), InitClient.checkItemHoldTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.RAILING_STAIR_GLASS, new Identifier("msd", "hold"), InitClient.checkItemHoldTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.RAILING_STAIR_GLASS_MIRROR, new Identifier("msd", "hold"), InitClient.checkItemHoldTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.STANDING_SIGN, new Identifier("msd", "hold"), InitClient.checkItemHoldTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.STANDING_SIGN_1, new Identifier("msd", "hold"), InitClient.checkItemHoldTag());
        REGISTRY_CLIENT.registerItemModelPredicate(Items.STANDING_SIGN_POLE, new Identifier("msd", "hold"), InitClient.checkItemHoldTag());
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_2_EVEN, RenderYamanoteRailwaySign::new);
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_2_ODD, RenderYamanoteRailwaySign::new);
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_3_EVEN, RenderYamanoteRailwaySign::new);
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_3_ODD, RenderYamanoteRailwaySign::new);
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_4_EVEN, RenderYamanoteRailwaySign::new);
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_4_ODD, RenderYamanoteRailwaySign::new);
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_5_EVEN, RenderYamanoteRailwaySign::new);
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_5_ODD, RenderYamanoteRailwaySign::new);
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_6_EVEN, RenderYamanoteRailwaySign::new);
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_6_ODD, RenderYamanoteRailwaySign::new);
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_7_EVEN, RenderYamanoteRailwaySign::new);
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YAMANOTE_RAILWAY_SIGN_ENTITY_7_ODD, RenderYamanoteRailwaySign::new);
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.STANDING_SIGN, argument -> new RenderCustomText((BlockEntityRenderer.Argument)argument, 3, 8.0f, 14.5f, 7.01f, 15.0f, 11.0f, true, 2.0f, 3.1f, 6.2f, 0.004f, 0xFFFFFF, 0, 0));
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.STANDING_SIGN_1, argument -> new RenderCustomText((BlockEntityRenderer.Argument)argument, 1, 2.5f, 9.25f, 7.65f, 4.0f, 11.0f, true, 1.6f, 1.6f, 3.2f, 0.0625f, 0xFFFFFF));
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YUUNI_PIDS, argument -> new RenderPIDS(argument, 2.5f, 7.5f, 6.0f, 6.5f, 27, true, 1.25f));
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YUUNI_2_PIDS, argument -> new RenderPIDS(argument, 4.0f, 7.5f, 5.9f, 2.5f, 24, true, 1.0f));
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YAMANOTE_4_PIDS, argument -> new RenderPIDS(argument, 0.0f, 15.0f, 7.0f, 6.0f, 32, true, 1.0f));
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YAMANOTE_5_PIDS, argument -> new RenderPIDS(argument, -4.0f, 15.0f, 7.0f, 6.0f, 40, true, 1.0f));
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YAMANOTE_6_PIDS, argument -> new RenderPIDS(argument, -8.0f, 15.0f, 7.0f, 6.0f, 48, true, 1.0f));
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.YAMANOTE_7_PIDS, argument -> new RenderPIDS(argument, -12.0f, 15.0f, 7.0f, 6.0f, 56, true, 1.0f));
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.CATENARY_WITH_LONG, argument -> new RenderCatenaryModel((BlockEntityRenderer.Argument)argument, BlockCatenaryWithModel.CatenaryModel.CATENARY_LONG));
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.CATENARY_WITH_LONG_TOP, argument -> new RenderCatenaryModel((BlockEntityRenderer.Argument)argument, BlockCatenaryWithModel.CatenaryModel.CATENARY_LONG_TOP));
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.CATENARY_WITH_SHORT, argument -> new RenderCatenaryModel((BlockEntityRenderer.Argument)argument, BlockCatenaryWithModel.CatenaryModel.CATENARY_SHORT));
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.CATENARY_WITH_SHORT_TOP, argument -> new RenderCatenaryModel((BlockEntityRenderer.Argument)argument, BlockCatenaryWithModel.CatenaryModel.CATENARY_SHORT_TOP));
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.CATENARY_WITH_LONG_COUNTERWEIGHT, argument -> new RenderCatenaryModel((BlockEntityRenderer.Argument)argument, BlockCatenaryWithModel.CatenaryModel.CATENARY_LONG_COUNTERWEIGHT));
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.CATENARY_WITH_LONG_COUNTERWEIGHT_MIRROR, argument -> new RenderCatenaryModel((BlockEntityRenderer.Argument)argument, BlockCatenaryWithModel.CatenaryModel.CATENARY_LONG_COUNTERWEIGHT_MIRROR));
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.CATENARY_WITH_SHORT_COUNTERWEIGHT, argument -> new RenderCatenaryModel((BlockEntityRenderer.Argument)argument, BlockCatenaryWithModel.CatenaryModel.CATENARY_SHORT_COUNTERWEIGHT));
        REGISTRY_CLIENT.registerBlockEntityRenderer(BlockEntityTypes.CATENARY_WITH_SHORT_COUNTERWEIGHT_MIRROR, argument -> new RenderCatenaryModel((BlockEntityRenderer.Argument)argument, BlockCatenaryWithModel.CatenaryModel.CATENARY_SHORT_COUNTERWEIGHT_MIRROR));
        REGISTRY_CLIENT.setupPackets(new Identifier("msd", "packet"));
        InitClient.REGISTRY_CLIENT.eventRegistryClient.registerClientJoin(() -> {
            MSDMinecraftClientData.reset();
            lastMillis = System.currentTimeMillis();
            gameMillis = 0L;
        });
        InitClient.REGISTRY_CLIENT.eventRegistryClient.registerStartClientTick(() -> {
            InitClient.incrementGameMillis();
            ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
            if (clientPlayerEntity != null && lastUpdatePacketMillis >= 0L && InitClient.getGameMillis() - lastUpdatePacketMillis > 500L) {
                MSDDataRequest dataRequest = new MSDDataRequest(clientPlayerEntity.getUuidAsString(), org.mtr.mod.Init.blockPosToPosition((BlockPos)MinecraftClient.getInstance().getGameRendererMapped().getCamera().getBlockPos()), (long)MinecraftClientHelper.getRenderDistance() * 16L);
                dataRequest.writeExistingIds(MSDMinecraftClientData.getInstance());
                REGISTRY_CLIENT.sendPacketToServer((PacketHandler)new MSDPacketRequestData(dataRequest));
                lastUpdatePacketMillis = -1L;
            }
        });
        InitClient.REGISTRY_CLIENT.eventRegistryClient.registerChunkLoad((clientWorld, worldChunk) -> {
            if (lastUpdatePacketMillis < 0L) {
                lastUpdatePacketMillis = InitClient.getGameMillis();
            }
        });
        Config.refreshProperties();
        REGISTRY_CLIENT.init();
    }

    public static long getGameMillis() {
        return gameMillis;
    }

    public static void incrementGameMillis() {
        long currentMillis = System.currentTimeMillis();
        long millisElapsed = currentMillis - lastMillis;
        lastMillis = currentMillis;
        gameMillis += millisElapsed;
    }

    private static RegistryClient.ModelPredicateProvider checkItemPredicateTag() {
        return (itemStack, clientWorld, livingEntity) -> itemStack.getOrCreateTag().contains("catenary_pos") ? 1.0f : 0.0f;
    }

    private static RegistryClient.ModelPredicateProvider checkItemHoldTag() {
        return (itemStack, clientWorld, livingEntity) -> itemStack.getOrCreateTag().contains("hold_num") ? (float)itemStack.getOrCreateTag().getInt("hold_num") / 10.0f : 0.0f;
    }

    public static Station findStation(BlockPos blockPos) {
        return MinecraftClientData.getInstance().stations.stream().filter(station -> station.inArea(org.mtr.mod.Init.blockPosToPosition((BlockPos)blockPos))).findFirst().orElse(null);
    }
}

