/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.screen;

import java.util.Objects;
import net.minecraft.client.gui.components.AbstractWidget;
import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.Init;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import top.mcmtr.core.data.Catenary;
import top.mcmtr.core.data.OffsetPosition;
import top.mcmtr.core.operation.MSDResetDataRequest;
import top.mcmtr.mod.InitClient;
import top.mcmtr.mod.blocks.BlockCatenaryWithModel;
import top.mcmtr.mod.client.MSDMinecraftClientData;
import top.mcmtr.mod.packet.MSDPacketResetData;
import top.mcmtr.mod.packet.MSDPacketUpdateModel;

public final class CatenaryWithModelScreen
extends ScreenExtension
implements IGui {
    private final TextFieldWidgetExtension textFieldTranslateX;
    private final TextFieldWidgetExtension textFieldTranslateY;
    private final TextFieldWidgetExtension textFieldTranslateZ;
    private final TextFieldWidgetExtension textFieldRotateY;
    private static final MutableText MODEL_TRANSLATION_TEXT = TextHelper.translatable((String)"gui.mtr.model_translation", (Object[])new Object[0]);
    private static final MutableText MODEL_ROTATION_TEXT = TextHelper.translatable((String)"gui.mtr.model_rotation", (Object[])new Object[0]);
    private static final MutableText X_TEXT = TextHelper.literal((String)"X");
    private static final MutableText Y_TEXT = TextHelper.literal((String)"Y");
    private static final MutableText Z_TEXT = TextHelper.literal((String)"Z");
    private static final int MAX_NUMBER_TEXT_LENGTH = 10;
    private final BlockPos blockPos;
    private final BlockCatenaryWithModel.BlockCatenaryWithModelEntity blockEntity;
    private final boolean isConnected;
    private final int xStart;
    private final double offsetXDefault;
    private final double offsetYDefault;
    private final double offsetZDefault;
    private final double rotationYDefault;

    public CatenaryWithModelScreen(BlockPos blockPos, boolean isConnected) {
        ClientWorld world = MinecraftClient.getInstance().getWorldMapped();
        if (world != null && world.getBlockEntity(blockPos) != null) {
            this.blockPos = blockPos;
            this.isConnected = isConnected;
            this.blockEntity = (BlockCatenaryWithModel.BlockCatenaryWithModelEntity)((Object)Objects.requireNonNull(world.getBlockEntity((BlockPos)blockPos)).data);
            this.offsetXDefault = this.blockEntity.getOffsetPosition().getX();
            this.offsetYDefault = this.blockEntity.getOffsetPosition().getY();
            this.offsetZDefault = this.blockEntity.getOffsetPosition().getZ();
            this.rotationYDefault = this.blockEntity.getRotation().getY();
            this.textFieldTranslateX = new TextFieldWidgetExtension(0, 0, 0, 20, 10, TextCase.DEFAULT, "[^\\d.-]", null);
            this.textFieldTranslateX.setChangedListener2(text -> this.updateClient());
            this.textFieldTranslateY = new TextFieldWidgetExtension(0, 0, 0, 20, 10, TextCase.DEFAULT, "[^\\d.-]", null);
            this.textFieldTranslateY.setChangedListener2(text -> this.updateClient());
            this.textFieldTranslateZ = new TextFieldWidgetExtension(0, 0, 0, 20, 10, TextCase.DEFAULT, "[^\\d.-]", null);
            this.textFieldTranslateZ.setChangedListener2(text -> this.updateClient());
            this.textFieldRotateY = new TextFieldWidgetExtension(0, 0, 0, 20, 10, TextCase.DEFAULT, "[^\\d.]", null);
            this.textFieldRotateY.setChangedListener2(text -> this.updateClient());
            this.xStart = Math.max(GraphicsHolder.getTextWidth((MutableText)X_TEXT), Math.max(GraphicsHolder.getTextWidth((MutableText)Y_TEXT), GraphicsHolder.getTextWidth((MutableText)Z_TEXT)));
        } else {
            this.blockPos = null;
            this.blockEntity = null;
            this.xStart = 0;
            this.textFieldTranslateX = null;
            this.textFieldTranslateY = null;
            this.textFieldTranslateZ = null;
            this.textFieldRotateY = null;
            this.offsetXDefault = 0.0;
            this.offsetYDefault = 0.0;
            this.offsetZDefault = 0.0;
            this.rotationYDefault = 0.0;
            this.isConnected = false;
        }
    }

    protected void init2() {
        if (this.blockEntity != null) {
            IDrawing.setPositionAndWidth((TextFieldWidgetExtension)this.textFieldTranslateX, (int)(20 + this.xStart + 6), (int)62, (int)80);
            IDrawing.setPositionAndWidth((TextFieldWidgetExtension)this.textFieldTranslateY, (int)(20 + this.xStart + 6), (int)86, (int)80);
            IDrawing.setPositionAndWidth((TextFieldWidgetExtension)this.textFieldTranslateZ, (int)(20 + this.xStart + 6), (int)110, (int)80);
            IDrawing.setPositionAndWidth((TextFieldWidgetExtension)this.textFieldRotateY, (int)(this.f_96543_ / 2 + this.xStart + 6), (int)66, (int)80);
            this.textFieldTranslateX.setText2(String.valueOf(this.offsetXDefault));
            this.textFieldTranslateY.setText2(String.valueOf(this.offsetYDefault));
            this.textFieldTranslateZ.setText2(String.valueOf(this.offsetZDefault));
            this.textFieldRotateY.setText2(String.valueOf(this.rotationYDefault));
            this.addChild(new ClickableWidget((AbstractWidget)this.textFieldTranslateX));
            this.addChild(new ClickableWidget((AbstractWidget)this.textFieldTranslateY));
            this.addChild(new ClickableWidget((AbstractWidget)this.textFieldTranslateZ));
            this.addChild(new ClickableWidget((AbstractWidget)this.textFieldRotateY));
        }
    }

    public void tick2() {
        super.tick2();
        if (this.blockEntity != null) {
            this.textFieldTranslateX.tick2();
            this.textFieldTranslateY.tick2();
            this.textFieldTranslateZ.tick2();
            this.textFieldRotateY.tick2();
        }
    }

    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        if (this.blockEntity != null) {
            this.renderBackground(graphicsHolder);
            super.render(graphicsHolder, mouseX, mouseY, delta);
            graphicsHolder.drawText(MODEL_TRANSLATION_TEXT, 20, 46, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(X_TEXT, 20, 68, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(Y_TEXT, 20, 92, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(Z_TEXT, 20, 116, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(MODEL_ROTATION_TEXT, this.f_96543_ / 2, 46, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText(Y_TEXT, this.f_96543_ / 2, 68, -1, false, GraphicsHolder.getDefaultLight());
        }
    }

    public boolean isPauseScreen2() {
        return false;
    }

    public void onClose2() {
        if (this.blockEntity != null) {
            super.onClose2();
            OffsetPosition offsetPosition = new OffsetPosition(CatenaryWithModelScreen.parse(this.textFieldTranslateX.getText2(), -1.0, 1.0), CatenaryWithModelScreen.parse(this.textFieldTranslateY.getText2(), -1.0, 1.0), CatenaryWithModelScreen.parse(this.textFieldTranslateZ.getText2(), -1.0, 1.0));
            OffsetPosition rotationPosition = new OffsetPosition(0.0, CatenaryWithModelScreen.parse(this.textFieldRotateY.getText2(), 0.0, 360.0), 0.0);
            Position position = Init.blockPosToPosition((BlockPos)this.blockPos);
            InitClient.REGISTRY_CLIENT.sendPacketToServer((PacketHandler)new MSDPacketUpdateModel(this.blockPos, offsetPosition, rotationPosition));
            InitClient.REGISTRY_CLIENT.sendPacketToServer((PacketHandler)new MSDPacketResetData(new MSDResetDataRequest(MSDMinecraftClientData.getInstance()).addCatenaryNodePosition(position).addOffsetPosition(offsetPosition)));
        }
    }

    private void updateClient() {
        OffsetPosition offsetPosition = new OffsetPosition(CatenaryWithModelScreen.parse(this.textFieldTranslateX.getText2(), -1.0, 1.0), CatenaryWithModelScreen.parse(this.textFieldTranslateY.getText2(), -1.0, 1.0), CatenaryWithModelScreen.parse(this.textFieldTranslateZ.getText2(), -1.0, 1.0));
        OffsetPosition rotationPosition = new OffsetPosition(0.0, CatenaryWithModelScreen.parse(this.textFieldRotateY.getText2(), 0.0, 360.0), 0.0);
        this.blockEntity.setOffsetPosition(offsetPosition, rotationPosition);
        if (this.isConnected) {
            MSDMinecraftClientData clientData = MSDMinecraftClientData.getInstance();
            Position position = Init.blockPosToPosition((BlockPos)this.blockPos);
            ((Object2ObjectOpenHashMap)clientData.positionsToCatenary.get((Object)position)).forEach((endPosition, catenary) -> {
                clientData.catenaries.remove((Object)catenary);
                clientData.catenaries.add((Object)Catenary.copy(catenary, position.equals((Object)catenary.getPosition1()) ? offsetPosition : catenary.getOffsetPositionStart(), position.equals((Object)catenary.getPosition2()) ? offsetPosition : catenary.getOffsetPositionEnd()));
            });
            clientData.sync();
        }
    }

    private static double parse(String text, double mixValue, double maxValue) {
        try {
            double number = Double.parseDouble(text);
            return number < mixValue ? mixValue : Math.min(number, maxValue);
        }
        catch (Exception ignored) {
            return 0.0;
        }
    }
}

