/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.common.impl.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.darkhax.tipsmod.common.api.TipsAPI;
import net.darkhax.tipsmod.common.api.tips.ITip;
import net.darkhax.tipsmod.common.impl.TipsMod;
import net.darkhax.tipsmod.common.impl.config.Config;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TipManager
extends SimpleJsonResourceReloadListener {
    public static final TipManager INSTANCE = new TipManager();
    private final Map<ResourceLocation, ITip> loadedTips = new HashMap<ResourceLocation, ITip>();
    private final Map<ITip, ResourceLocation> reverseLookup = new HashMap<ITip, ResourceLocation>();
    private final List<ITip> randomAccess = new LinkedList<ITip>();
    private final List<ITip> immutableAccess = Collections.unmodifiableList(this.randomAccess);

    private TipManager() {
        super(new Gson(), "tips");
    }

    public List<ITip> getTips() {
        return this.immutableAccess;
    }

    @Nullable
    public ResourceLocation getKey(ITip tip) {
        return this.reverseLookup.get(tip);
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        this.loadedTips.clear();
        this.reverseLookup.clear();
        this.randomAccess.clear();
        long startTime = System.nanoTime();
        Config config = (Config)TipsMod.CONFIG.get();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            if (config.ignored_namespaces.contains(entry.getKey().getNamespace()) || config.ignored_tip_ids.contains(entry.getKey().toString())) continue;
            try {
                ITip tip = (ITip)((Pair)TipsAPI.TIP_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).getOrThrow()).getFirst();
                this.loadedTips.put(entry.getKey(), tip);
                this.reverseLookup.put(tip, entry.getKey());
                this.randomAccess.add(tip);
            }
            catch (Exception e) {
                TipsMod.LOG.error("Failed to load tip {}.", (Object)entry.getKey(), (Object)e);
            }
        }
        Collections.shuffle(this.randomAccess);
        TipsMod.LOG.info("Loaded {} tips. Took {}ms.", (Object)this.loadedTips.size(), (Object)((double)(System.nanoTime() - startTime) / 1000000.0));
    }
}

