/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.common.impl.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.darkhax.tipsmod.common.api.TipsAPI;
import net.darkhax.tipsmod.common.api.tips.ITip;
import net.darkhax.tipsmod.common.impl.TipsMod;
import net.darkhax.tipsmod.common.impl.config.Config;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TipManager
extends class_4309 {
    public static final TipManager INSTANCE = new TipManager();
    private final Map<class_2960, ITip> loadedTips = new HashMap<class_2960, ITip>();
    private final Map<ITip, class_2960> reverseLookup = new HashMap<ITip, class_2960>();
    private final List<ITip> randomAccess = new LinkedList<ITip>();
    private final List<ITip> immutableAccess = Collections.unmodifiableList(this.randomAccess);

    private TipManager() {
        super(new Gson(), "tips");
    }

    public List<ITip> getTips() {
        return this.immutableAccess;
    }

    @Nullable
    public class_2960 getKey(ITip tip) {
        return this.reverseLookup.get(tip);
    }

    protected void apply(Map<class_2960, JsonElement> map, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        this.loadedTips.clear();
        this.reverseLookup.clear();
        this.randomAccess.clear();
        long startTime = System.nanoTime();
        Config config = (Config)TipsMod.CONFIG.get();
        for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
            if (config.ignored_namespaces.contains(entry.getKey().method_12836()) || config.ignored_tip_ids.contains(entry.getKey().toString())) continue;
            try {
                ITip tip = (ITip)((Pair)TipsAPI.TIP_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).getOrThrow()).getFirst();
                this.loadedTips.put(entry.getKey(), tip);
                this.reverseLookup.put(tip, entry.getKey());
                this.randomAccess.add(tip);
            }
            catch (Exception e) {
                TipsMod.LOG.error("Failed to load tip {}.", (Object)entry.getKey(), (Object)e);
            }
        }
        Collections.shuffle(this.randomAccess);
        TipsMod.LOG.info("Loaded {} tips. Took {}ms.", (Object)this.loadedTips.size(), (Object)((double)(System.nanoTime() - startTime) / 1000000.0));
    }
}

